/*
 * Decompiled with CFR 0.152.
 */
package com.rejahtavi.rfp2;

import com.rejahtavi.rfp2.EntityPlayerDummy;
import com.rejahtavi.rfp2.RFP2;
import com.rejahtavi.rfp2.RFP2Config;
import goblinbob.mobends.core.bender.EntityBender;
import goblinbob.mobends.core.bender.EntityBenderRegistry;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RFP2State {
    EntityPlayerDummy dummy = null;
    int spawnDelay = 40;
    long checkEnableModDelay = 0L;
    long checkEnableRealArmsDelay = 0L;
    int suspendApiDelay = 0;
    boolean lastActivateCheckResult = true;
    boolean lastRealArmsCheckResult = true;
    boolean enableMod;
    boolean enableRealArms;
    boolean enableHeadTurning;
    boolean enableStatusMessages;
    boolean conflictsDetected = false;
    boolean conflictCheckDone = false;

    public RFP2State() {
        this.enableMod = RFP2Config.preferences.enableMod;
        this.enableRealArms = RFP2Config.preferences.enableRealArms;
        this.enableHeadTurning = RFP2Config.preferences.enableHeadTurning;
        this.enableStatusMessages = RFP2Config.preferences.enableStatusMessages;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(InputEvent.KeyInputEvent event) {
        if (RFP2Config.compatibility.disableKeyBinding) {
            return;
        }
        if (RFP2.keybindModToggle.checkForNewPress()) {
            boolean bl2 = this.enableMod = !this.enableMod;
            if (this.enableStatusMessages) {
                RFP2.logToChat("\u7b2c\u4e09\u4eba\u79f0\u89c6\u89d2\u5f53\u524d\u72b6\u6001: " + (this.enableMod ? TextFormatting.GREEN + "enabled" : TextFormatting.RED + "disabled"));
            }
        }
    }

    public void detectModConflicts(EntityPlayer player) {
        if (!this.conflictCheckDone) {
            String modConflictList = "";
            for (String conflictingID : RFP2.CONFLICT_MODIDS) {
                if (!Loader.isModLoaded((String)conflictingID)) continue;
                if (modConflictList.length() != 0) {
                    modConflictList = modConflictList + ", ";
                }
                modConflictList = modConflictList + conflictingID;
            }
            if (modConflictList.length() != 0) {
                if (RFP2Config.compatibility.disableModCompatibilityAlerts) {
                    RFP2.logger.log(RFP2.LOGGING_LEVEL_HIGH, this.getClass().getName() + ": WARNING: In-game compatibility alerts have been disabled!");
                } else {
                    RFP2.logToChatByPlayer("" + TextFormatting.BOLD + TextFormatting.GOLD + "WARNING: RFP2 has known compatibility issues with the mod(s): " + TextFormatting.RESET + TextFormatting.RED + modConflictList + ".", player);
                    RFP2.logToChatByPlayer("" + TextFormatting.BOLD + TextFormatting.GOLD + "Be aware that visual glitches may occur.", player);
                    RFP2.logToChatByPlayer("Press the hotkey (Default: Apostrophe) to use RFP2 anyway.", player);
                    RFP2.logToChatByPlayer("" + TextFormatting.RESET + TextFormatting.GRAY + "(You can disable this warning in mod options.)", player);
                    this.conflictsDetected = true;
                    this.enableMod = false;
                }
                RFP2.logger.log(RFP2.LOGGING_LEVEL_HIGH, this.getClass().getName() + ": WARNING: Detected conflicting mod(s): " + modConflictList);
            }
            this.conflictCheckDone = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEvent(RenderHandEvent event) {
        EntityBender<AbstractClientPlayer> forEntityClass;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && RFP2.state.isModEnabled((EntityPlayer)player) && RFP2.state.isRealArmsEnabled((EntityPlayer)player) && (forEntityClass = EntityBenderRegistry.instance.getForEntityClass(AbstractClientPlayer.class)).isAnimated()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e2) {
        if (e2.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            this.resetDummy();
            this.spawnDelay = 0;
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ClientTickEvent event) {
        try {
            EntityPlayerSP player;
            if (this.checkEnableModDelay > 0L) {
                --this.checkEnableModDelay;
            }
            if (this.checkEnableRealArmsDelay > 0L) {
                --this.checkEnableRealArmsDelay;
            }
            if (this.suspendApiDelay > 0) {
                --this.suspendApiDelay;
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) != null) {
                if (this.dummy == null) {
                    if (this.spawnDelay > 0) {
                        this.spawnDelay = this.enableMod ? --this.spawnDelay : 40;
                    } else {
                        this.attemptDummySpawn((EntityPlayer)player);
                    }
                } else {
                    boolean needsReset = false;
                    if (this.dummy.field_70170_p.field_73011_w.getDimension() != player.field_70170_p.field_73011_w.getDimension()) {
                        needsReset = true;
                        RFP2.logger.log(RFP2.LOGGING_LEVEL_DEBUG, this.getClass().getName() + ": Respawning dummy because player changed dimension.");
                    }
                    if (this.dummy.func_70068_e((Entity)player) > 5.0) {
                        needsReset = true;
                        RFP2.logger.log(RFP2.LOGGING_LEVEL_DEBUG, this.getClass().getName() + ": Respawning dummy because player and dummy became separated.");
                    }
                    if (this.dummy.lastTickUpdated < player.field_70170_p.func_82737_E() - 20L) {
                        needsReset = true;
                        RFP2.logger.log(RFP2.LOGGING_LEVEL_DEBUG, this.getClass().getName() + ": Respawning dummy because state became stale. (Is the server lagging?)");
                    }
                    if (needsReset) {
                        this.resetDummy();
                    }
                }
            }
        }
        catch (Exception e2) {
            RFP2.errorDisableMod(this.getClass().getName() + ".onEvent(TickEvent.ClientTickEvent)", e2);
        }
    }

    void attemptDummySpawn(EntityPlayer player) {
        this.detectModConflicts(player);
        try {
            if (this.dummy != null) {
                this.dummy.func_70106_y();
            }
            this.dummy = new EntityPlayerDummy(player.field_70170_p);
            this.dummy.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            player.field_70170_p.func_72838_d((Entity)this.dummy);
        }
        catch (Exception e2) {
            RFP2.logger.log(RFP2.LOGGING_LEVEL_MED, this.getClass().getName() + ": failed to spawn PlayerDummy! Will retry. Exception:", (Object)e2.toString());
            e2.printStackTrace();
            this.resetDummy();
        }
    }

    void resetDummy() {
        if (this.dummy != null) {
            this.dummy.func_70106_y();
        }
        this.dummy = null;
        this.spawnDelay = 40;
    }

    public void setSuspendTimer(int ticks) {
        if (ticks > 0 && ticks <= 60 && ticks > this.suspendApiDelay) {
            this.suspendApiDelay = ticks;
        }
    }

    public boolean isModEnabled(EntityPlayer player) {
        if (!this.enableMod) {
            return false;
        }
        if (this.suspendApiDelay > 0) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.dummy == null) {
            return false;
        }
        if (this.checkEnableModDelay == 0L) {
            Entity playerMountEntity;
            this.checkEnableModDelay = 4L;
            this.lastActivateCheckResult = RFP2Config.compatibility.disableWhenSwimming && this.dummy.isSwimming() ? false : ((playerMountEntity = player.func_184187_bx()) == null ? true : !this.stringMatchesRegexList(playerMountEntity.func_70005_c_().toLowerCase(), RFP2Config.compatibility.mountConflictList));
        }
        return this.lastActivateCheckResult;
    }

    public boolean isRealArmsEnabled(EntityPlayer player) {
        if (!this.enableRealArms) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.checkEnableRealArmsDelay == 0L) {
            this.checkEnableRealArmsDelay = 1L;
            String itemMainHand = player.field_71071_by.func_70448_g().func_77973_b().getRegistryName().toString().toLowerCase();
            String itemOffHand = ((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b().getRegistryName().toString().toLowerCase();
            this.lastRealArmsCheckResult = RFP2Config.compatibility.disableArmsWhenAnyItemHeld ? itemMainHand.equals("minecraft:air") && itemOffHand.equals("minecraft:air") : this.stringMatchesRegexList(itemMainHand, RFP2Config.compatibility.heldItemConflictList) || this.stringMatchesRegexList(itemOffHand, RFP2Config.compatibility.heldItemConflictList);
        }
        return this.lastRealArmsCheckResult;
    }

    public boolean isHeadRotationEnabled(EntityPlayer player) {
        return this.enableHeadTurning;
    }

    boolean stringMatchesRegexList(String string, String[] regexes) {
        for (String i2 : regexes) {
            try {
                if (!string.matches(i2)) continue;
                return true;
            }
            catch (PatternSyntaxException e2) {
                this.enableMod = false;
                RFP2.logToChat("Real First Person 2 " + TextFormatting.RED + "Warning: [ " + i2 + " ] is not a valid regex, please edit your configuration.");
                RFP2.logToChat("Real First Person 2 mod " + TextFormatting.RED + " disabled");
                return false;
            }
        }
        return false;
    }
}

