/*
 * Decompiled with CFR 0.152.
 */
package com.github.timmyovo.virtualui.common.render.texture;

public final class TextureAttribute {
    private final double textureWidthRatio;
    private final double textureHeightRatio;
    private final double textureWidthAddition;
    private final double textureHeightAddition;

    TextureAttribute(double textureWidthRatio, double textureHeightRatio, double textureWidthAddition, double textureHeightAddition) {
        this.textureWidthRatio = textureWidthRatio;
        this.textureHeightRatio = textureHeightRatio;
        this.textureWidthAddition = textureWidthAddition;
        this.textureHeightAddition = textureHeightAddition;
    }

    public static TextureAttributeBuilder builder() {
        return new TextureAttributeBuilder();
    }

    public TextureAttributeBuilder toBuilder() {
        return new TextureAttributeBuilder().textureWidthRatio(this.textureWidthRatio).textureHeightRatio(this.textureHeightRatio).textureWidthAddition(this.textureWidthAddition).textureHeightAddition(this.textureHeightAddition);
    }

    public double getTextureWidthRatio() {
        return this.textureWidthRatio;
    }

    public double getTextureHeightRatio() {
        return this.textureHeightRatio;
    }

    public double getTextureWidthAddition() {
        return this.textureWidthAddition;
    }

    public double getTextureHeightAddition() {
        return this.textureHeightAddition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextureAttribute)) {
            return false;
        }
        TextureAttribute other = (TextureAttribute)o;
        if (Double.compare(this.getTextureWidthRatio(), other.getTextureWidthRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getTextureHeightRatio(), other.getTextureHeightRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getTextureWidthAddition(), other.getTextureWidthAddition()) != 0) {
            return false;
        }
        return Double.compare(this.getTextureHeightAddition(), other.getTextureHeightAddition()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $textureWidthRatio = Double.doubleToLongBits(this.getTextureWidthRatio());
        result = result * 59 + (int)($textureWidthRatio >>> 32 ^ $textureWidthRatio);
        long $textureHeightRatio = Double.doubleToLongBits(this.getTextureHeightRatio());
        result = result * 59 + (int)($textureHeightRatio >>> 32 ^ $textureHeightRatio);
        long $textureWidthAddition = Double.doubleToLongBits(this.getTextureWidthAddition());
        result = result * 59 + (int)($textureWidthAddition >>> 32 ^ $textureWidthAddition);
        long $textureHeightAddition = Double.doubleToLongBits(this.getTextureHeightAddition());
        result = result * 59 + (int)($textureHeightAddition >>> 32 ^ $textureHeightAddition);
        return result;
    }

    public String toString() {
        return "TextureAttribute(textureWidthRatio=" + this.getTextureWidthRatio() + ", textureHeightRatio=" + this.getTextureHeightRatio() + ", textureWidthAddition=" + this.getTextureWidthAddition() + ", textureHeightAddition=" + this.getTextureHeightAddition() + ")";
    }

    public static class TextureAttributeBuilder {
        private double textureWidthRatio;
        private double textureHeightRatio;
        private double textureWidthAddition;
        private double textureHeightAddition;

        TextureAttributeBuilder() {
        }

        public TextureAttributeBuilder textureWidthRatio(double textureWidthRatio) {
            this.textureWidthRatio = textureWidthRatio;
            return this;
        }

        public TextureAttributeBuilder textureHeightRatio(double textureHeightRatio) {
            this.textureHeightRatio = textureHeightRatio;
            return this;
        }

        public TextureAttributeBuilder textureWidthAddition(double textureWidthAddition) {
            this.textureWidthAddition = textureWidthAddition;
            return this;
        }

        public TextureAttributeBuilder textureHeightAddition(double textureHeightAddition) {
            this.textureHeightAddition = textureHeightAddition;
            return this;
        }

        public TextureAttribute build() {
            return new TextureAttribute(this.textureWidthRatio, this.textureHeightRatio, this.textureWidthAddition, this.textureHeightAddition);
        }

        public String toString() {
            return "TextureAttribute.TextureAttributeBuilder(textureWidthRatio=" + this.textureWidthRatio + ", textureHeightRatio=" + this.textureHeightRatio + ", textureWidthAddition=" + this.textureWidthAddition + ", textureHeightAddition=" + this.textureHeightAddition + ")";
        }
    }
}

