/*
 * Decompiled with CFR 0.152.
 */
package com.github.timmyovo.virtualui.common.render;

public final class RenderScreenPosition {
    private final double screenXRatio;
    private final double screenYRatio;
    private final double screenXOffset;
    private final double screenYOffset;

    RenderScreenPosition(double screenXRatio, double screenYRatio, double screenXOffset, double screenYOffset) {
        this.screenXRatio = screenXRatio;
        this.screenYRatio = screenYRatio;
        this.screenXOffset = screenXOffset;
        this.screenYOffset = screenYOffset;
    }

    public static RenderScreenPositionBuilder builder() {
        return new RenderScreenPositionBuilder();
    }

    public RenderScreenPositionBuilder toBuilder() {
        return new RenderScreenPositionBuilder().screenXRatio(this.screenXRatio).screenYRatio(this.screenYRatio).screenXOffset(this.screenXOffset).screenYOffset(this.screenYOffset);
    }

    public double getScreenXRatio() {
        return this.screenXRatio;
    }

    public double getScreenYRatio() {
        return this.screenYRatio;
    }

    public double getScreenXOffset() {
        return this.screenXOffset;
    }

    public double getScreenYOffset() {
        return this.screenYOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderScreenPosition)) {
            return false;
        }
        RenderScreenPosition other = (RenderScreenPosition)o;
        if (Double.compare(this.getScreenXRatio(), other.getScreenXRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getScreenYRatio(), other.getScreenYRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getScreenXOffset(), other.getScreenXOffset()) != 0) {
            return false;
        }
        return Double.compare(this.getScreenYOffset(), other.getScreenYOffset()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $screenXRatio = Double.doubleToLongBits(this.getScreenXRatio());
        result = result * 59 + (int)($screenXRatio >>> 32 ^ $screenXRatio);
        long $screenYRatio = Double.doubleToLongBits(this.getScreenYRatio());
        result = result * 59 + (int)($screenYRatio >>> 32 ^ $screenYRatio);
        long $screenXOffset = Double.doubleToLongBits(this.getScreenXOffset());
        result = result * 59 + (int)($screenXOffset >>> 32 ^ $screenXOffset);
        long $screenYOffset = Double.doubleToLongBits(this.getScreenYOffset());
        result = result * 59 + (int)($screenYOffset >>> 32 ^ $screenYOffset);
        return result;
    }

    public String toString() {
        return "RenderScreenPosition(screenXRatio=" + this.getScreenXRatio() + ", screenYRatio=" + this.getScreenYRatio() + ", screenXOffset=" + this.getScreenXOffset() + ", screenYOffset=" + this.getScreenYOffset() + ")";
    }

    public static class RenderScreenPositionBuilder {
        private double screenXRatio;
        private double screenYRatio;
        private double screenXOffset;
        private double screenYOffset;

        RenderScreenPositionBuilder() {
        }

        public RenderScreenPositionBuilder screenXRatio(double screenXRatio) {
            this.screenXRatio = screenXRatio;
            return this;
        }

        public RenderScreenPositionBuilder screenYRatio(double screenYRatio) {
            this.screenYRatio = screenYRatio;
            return this;
        }

        public RenderScreenPositionBuilder screenXOffset(double screenXOffset) {
            this.screenXOffset = screenXOffset;
            return this;
        }

        public RenderScreenPositionBuilder screenYOffset(double screenYOffset) {
            this.screenYOffset = screenYOffset;
            return this;
        }

        public RenderScreenPosition build() {
            return new RenderScreenPosition(this.screenXRatio, this.screenYRatio, this.screenXOffset, this.screenYOffset);
        }

        public String toString() {
            return "RenderScreenPosition.RenderScreenPositionBuilder(screenXRatio=" + this.screenXRatio + ", screenYRatio=" + this.screenYRatio + ", screenXOffset=" + this.screenXOffset + ", screenYOffset=" + this.screenYOffset + ")";
        }
    }
}

