/*
 * Decompiled with CFR 0.152.
 */
package com.github.timmyovo.virtualui.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Compress {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream out = new DeflaterOutputStream(baos);
            ((OutputStream)out).write(text.getBytes("UTF-8"));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return baos.toByteArray();
    }

    public static String decompress(byte[] bytes) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        org.apache.commons.io.output.ByteArrayOutputStream output = new org.apache.commons.io.output.ByteArrayOutputStream();
        Compress.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = Compress.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return Compress.copy(input, output, 4096);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Compress.copyLarge(input, output, new byte[bufferSize]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

