/*
 * Decompiled with CFR 0.152.
 */
package com.github.timmyovo.virtualui.common.gui.component.impl;

import com.github.timmyovo.virtualui.common.gui.component.AbstractComponent;
import com.github.timmyovo.virtualui.common.gui.hover.ContentHover;
import com.github.timmyovo.virtualui.common.render.ComponentRenderMeta;
import com.github.timmyovo.virtualui.common.render.ItemRenderer;

public class ComponentPicture
extends AbstractComponent {
    private ItemRenderer itemRenderer;

    private ComponentPicture(Builder builder) {
        this.setName(builder.name);
        this.setVisible(builder.visible);
        this.setComponentRenderMeta(builder.componentRenderMeta);
        this.setContentHover(builder.contentHover);
        this.setItemRenderer(builder.itemRenderer);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public static final class Builder {
        private String name;
        private boolean visible;
        private ComponentRenderMeta componentRenderMeta;
        private ContentHover contentHover;
        private ItemRenderer itemRenderer;

        private Builder() {
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withVisible(boolean val) {
            this.visible = val;
            return this;
        }

        public Builder withComponentRenderMeta(ComponentRenderMeta val) {
            this.componentRenderMeta = val;
            return this;
        }

        public Builder withContentHover(ContentHover val) {
            this.contentHover = val;
            return this;
        }

        public Builder withItemRenderer(ItemRenderer val) {
            this.itemRenderer = val;
            return this;
        }

        public ComponentPicture build() {
            return new ComponentPicture(this);
        }
    }
}

