/*
 * Decompiled with CFR 0.152.
 */
package com.github.timmyovo.virtualui.common.gui;

import com.github.timmyovo.virtualui.common.gui.component.AbstractComponent;
import com.github.timmyovo.virtualui.common.render.ComponentRenderMeta;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;

public class ComponentContainer {
    @SerializedName(value="componentRenderMeta")
    private ComponentRenderMeta componentRenderMeta;
    @SerializedName(value="componentList")
    private List<AbstractComponent> componentList;

    public <T extends AbstractComponent> Optional<T> findComponentByName(String name) {
        return this.componentList.stream().filter(abstractComponent -> abstractComponent.getName().equals(name)).findFirst();
    }

    ComponentContainer(ComponentRenderMeta componentRenderMeta, List<AbstractComponent> componentList) {
        this.componentRenderMeta = componentRenderMeta;
        this.componentList = componentList;
    }

    public static ComponentContainerBuilder builder() {
        return new ComponentContainerBuilder();
    }

    public ComponentRenderMeta getComponentRenderMeta() {
        return this.componentRenderMeta;
    }

    public List<AbstractComponent> getComponentList() {
        return this.componentList;
    }

    public void setComponentRenderMeta(ComponentRenderMeta componentRenderMeta) {
        this.componentRenderMeta = componentRenderMeta;
    }

    public void setComponentList(List<AbstractComponent> componentList) {
        this.componentList = componentList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentContainer)) {
            return false;
        }
        ComponentContainer other = (ComponentContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbstractComponent> this$componentList = this.getComponentList();
        List<AbstractComponent> other$componentList = other.getComponentList();
        return !(this$componentList == null ? other$componentList != null : !((Object)this$componentList).equals(other$componentList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbstractComponent> $componentList = this.getComponentList();
        result = result * 59 + ($componentList == null ? 43 : ((Object)$componentList).hashCode());
        return result;
    }

    public static class ComponentContainerBuilder {
        private ComponentRenderMeta componentRenderMeta;
        private List<AbstractComponent> componentList;

        ComponentContainerBuilder() {
        }

        public ComponentContainerBuilder componentRenderMeta(ComponentRenderMeta componentRenderMeta) {
            this.componentRenderMeta = componentRenderMeta;
            return this;
        }

        public ComponentContainerBuilder componentList(List<AbstractComponent> componentList) {
            this.componentList = componentList;
            return this;
        }

        public ComponentContainer build() {
            return new ComponentContainer(this.componentRenderMeta, this.componentList);
        }

        public String toString() {
            return "ComponentContainer.ComponentContainerBuilder(componentRenderMeta=" + this.componentRenderMeta + ", componentList=" + this.componentList + ")";
        }
    }
}

