/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.launch.Blackboard;
import org.spongepowered.asm.launch.platform.MixinPlatformAgentAbstract;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class MixinPlatformAgentFML
extends MixinPlatformAgentAbstract {
    private static final String LOAD_CORE_MOD_METHOD = "loadCoreMod";
    private static final String GET_REPARSEABLE_COREMODS_METHOD = "getReparseableCoremods";
    private static final String CORE_MOD_MANAGER_CLASS = "net.minecraftforge.fml.relauncher.CoreModManager";
    private static final String GET_IGNORED_MODS_METHOD = "getIgnoredMods";
    private static final String FML_REMAPPER_ADAPTER_CLASS = "org.spongepowered.asm.bridge.RemapperAdapterFML";
    private static final String MFATT_FORCELOADASMOD = "ForceLoadAsMod";
    private static final String MFATT_FMLCOREPLUGIN = "FMLCorePlugin";
    private static final String MFATT_COREMODCONTAINSMOD = "FMLCorePluginContainsFMLMod";
    private final ITweaker coreModWrapper;
    private final String fileName;
    private Class<?> clCoreModManager;

    public MixinPlatformAgentFML(MixinPlatformManager manager, URI uri) {
        super(manager, uri);
        this.fileName = this.container.getName();
        this.coreModWrapper = this.initFMLCoreMod();
    }

    private ITweaker initFMLCoreMod() {
        try {
            this.clCoreModManager = MixinPlatformAgentFML.getCoreModManagerClass();
            if ("true".equalsIgnoreCase(this.attributes.get(MFATT_FORCELOADASMOD))) {
                MixinPlatformAgentAbstract.logger.debug("ForceLoadAsMod was specified for {}, attempting force-load", this.fileName);
                this.loadAsMod();
            }
            return this.injectCorePlugin();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void loadAsMod() {
        try {
            MixinPlatformAgentFML.getIgnoredMods(this.clCoreModManager).remove(this.fileName);
        }
        catch (Exception ex) {
            MixinPlatformAgentAbstract.logger.catching(ex);
        }
        if (this.attributes.get(MFATT_COREMODCONTAINSMOD) != null) {
            this.addReparseableJar();
        }
    }

    private void addReparseableJar() {
        try {
            Method mdGetReparsedCoremods = this.clCoreModManager.getDeclaredMethod(Blackboard.getString("mixin.launch.fml.reparseablecoremodsmethod", GET_REPARSEABLE_COREMODS_METHOD), new Class[0]);
            List reparsedCoremods = (List)mdGetReparsedCoremods.invoke(null, new Object[0]);
            if (!reparsedCoremods.contains(this.fileName)) {
                MixinPlatformAgentAbstract.logger.debug("Adding {} to reparseable coremod collection", this.fileName);
                reparsedCoremods.add(this.fileName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ITweaker injectCorePlugin() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String coreModName = this.attributes.get(MFATT_FMLCOREPLUGIN);
        if (coreModName == null) {
            return null;
        }
        MixinPlatformAgentAbstract.logger.debug("{} has core plugin {}. Injecting it into FML for co-initialisation:", this.fileName, coreModName);
        Method mdLoadCoreMod = this.clCoreModManager.getDeclaredMethod(Blackboard.getString("mixin.launch.fml.loadcoremodmethod", LOAD_CORE_MOD_METHOD), LaunchClassLoader.class, String.class, File.class);
        mdLoadCoreMod.setAccessible(true);
        ITweaker wrapper = (ITweaker)mdLoadCoreMod.invoke(null, Launch.classLoader, coreModName, this.container);
        if (wrapper == null) {
            MixinPlatformAgentAbstract.logger.debug("Core plugin {} could not be loaded.", coreModName);
            return null;
        }
        return wrapper;
    }

    @Override
    public String getPhaseProvider() {
        return MixinPlatformAgentFML.class.getName() + "$PhaseProvider";
    }

    @Override
    public void prepare() {
    }

    @Override
    public void initPrimaryContainer() {
        if (this.clCoreModManager != null) {
            this.injectRemapper();
        }
    }

    private void injectRemapper() {
        try {
            MixinPlatformAgentAbstract.logger.debug("Creating FML remapper adapter: {}", FML_REMAPPER_ADAPTER_CLASS);
            Class<?> clFmlRemapperAdapter = Class.forName(FML_REMAPPER_ADAPTER_CLASS, true, (ClassLoader)Launch.classLoader);
            Method mdCreate = clFmlRemapperAdapter.getDeclaredMethod("create", new Class[0]);
            IRemapper remapper = (IRemapper)mdCreate.invoke(null, new Object[0]);
            MixinEnvironment.getDefaultEnvironment().getRemappers().add(remapper);
        }
        catch (Exception ex) {
            MixinPlatformAgentAbstract.logger.debug("Failed instancing FML remapper adapter, things will probably go horribly for notch-obf'd mods!");
        }
    }

    @Override
    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        if (this.coreModWrapper != null) {
            if (!this.isFMLInjected()) {
                MixinPlatformAgentAbstract.logger.debug("FML agent is co-initialising coremod instance {} for {}", this.coreModWrapper, this.uri);
                this.coreModWrapper.injectIntoClassLoader(classLoader);
            } else {
                MixinPlatformAgentAbstract.logger.debug("FML agent is skipping co-init for {} because FML already started", this.coreModWrapper);
            }
        }
    }

    @Override
    public String getLaunchTarget() {
        return null;
    }

    protected final boolean isFMLInjected() {
        for (String tweaker : (List)Blackboard.get("TweakClasses")) {
            if (!tweaker.endsWith("FMLDeobfTweaker")) continue;
            return true;
        }
        return false;
    }

    private static Class<?> getCoreModManagerClass() throws ClassNotFoundException {
        try {
            return Class.forName(Blackboard.getString("mixin.launch.fml.coremodmanagerclass", CORE_MOD_MANAGER_CLASS));
        }
        catch (ClassNotFoundException ex) {
            return Class.forName("cpw.mods.fml.relauncher.CoreModManager");
        }
    }

    private static List<String> getIgnoredMods(Class<?> clCoreModManager) throws IllegalAccessException, InvocationTargetException {
        Method mdGetIgnoredMods = null;
        try {
            mdGetIgnoredMods = clCoreModManager.getDeclaredMethod(Blackboard.getString("mixin.launch.fml.ignoredmodsmethod", GET_IGNORED_MODS_METHOD), new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                mdGetIgnoredMods = clCoreModManager.getDeclaredMethod("getLoadedCoremods", new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                MixinPlatformAgentAbstract.logger.catching(Level.DEBUG, ex2);
                return Collections.emptyList();
            }
        }
        return (List)mdGetIgnoredMods.invoke(null, new Object[0]);
    }
}

