/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.lesslag;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LesslagMod
extends DummyModContainer {
    public static final String ID = "lesslag";
    private static final String NAME = "Lesslag";
    private static final String VERSION = "1.0";
    private static Configuration config;
    private static LesslagMod instance;

    public LesslagMod() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = ID;
        meta.name = NAME;
        meta.version = VERSION;
        meta.credits = "Sharkske for inspiration, and Oriondevelopment for the awesome ASM help =D";
        meta.authorList = Collections.singletonList("Asherslab");
        meta.description = "A simple Coremod for increasing FPS by reducing Terrain Animations.";
        meta.url = "http://minecolonies.com";
        meta.screenshots = new String[0];
        meta.logoFile = "";
        config = null;
        File cfgFile = new File(Loader.instance().getConfigDir(), "lesslag.cfg");
        config = new Configuration(cfgFile);
        LesslagMod.syncConfig(true);
        instance = this;
    }

    private static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        if (!LesslagMod.config.isChild && load) {
            config.load();
        }
        Property prop = config.get("general", "allAnimations", false);
        prop.setComment("Render this mod literally useless, I'd suggest not. but what-ever");
        propOrder.add(prop.getName());
        prop = config.get("general", "waterAnimations", true);
        prop.setComment("Whether to allow Water Animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "lavaAnimations", true);
        prop.setComment("Whether to allow Lava Animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "clockAndCompassAnimations", true);
        prop.setComment("Whether to allow Clock and Compass Animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "portalAnimations", false);
        prop.setComment("Whether to allow Portal animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "fireAnimations", true);
        prop.setComment("Whether to allow Fire animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "glassAnimations", false);
        prop.setComment("Whether to allow glass animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "grassAnimations", false);
        prop.setComment("Whether to allow grass animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "snowAnimations", false);
        prop.setComment("Whether to allow snow animations or not");
        propOrder.add(prop.getName());
        prop = config.get("general", "myceliumAnimations", false);
        prop.setComment("Whether to allow mycelium animations or not");
        propOrder.add(prop.getName());
        config.setCategoryPropertyOrder("general", propOrder);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (this.getMetadata().modId.equals(event.getModID()) && "general".equals(event.getConfigID())) {
            LesslagMod.syncConfig(false);
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public void setEnabledState(boolean enabled) {
        super.setEnabledState(enabled);
    }

    public ModContainer.Disableable canBeDisabled() {
        return ModContainer.Disableable.NEVER;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static LesslagMod getInstance() {
        return instance;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getName() {
        return NAME;
    }

    public String getModId() {
        return ID;
    }

    public String getGuiClassName() {
        return "com.minecolonies.lesslag.config.LesslagGuiFactory";
    }
}

