/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.util.Arrays;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;
import org.msgpack.value.impl.AbstractImmutableRawValue;

public class ImmutableStringValueImpl
extends AbstractImmutableRawValue
implements ImmutableStringValue {
    public ImmutableStringValueImpl(byte[] data) {
        super(data);
    }

    public ImmutableStringValueImpl(String string) {
        super(string);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public ImmutableStringValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableStringValue asStringValue() {
        return this;
    }

    @Override
    public void writeTo(MessagePacker pk) throws IOException {
        pk.packRawStringHeader(this.data.length);
        pk.writePayload(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isStringValue()) {
            return false;
        }
        if (v instanceof ImmutableStringValueImpl) {
            ImmutableStringValueImpl bv = (ImmutableStringValueImpl)v;
            return Arrays.equals(this.data, bv.data);
        }
        return Arrays.equals(this.data, v.asStringValue().asByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

