/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.value.ImmutableRawValue;
import org.msgpack.value.impl.AbstractImmutableValue;

public abstract class AbstractImmutableRawValue
extends AbstractImmutableValue
implements ImmutableRawValue {
    protected final byte[] data;
    private volatile String decodedStringCache;
    private volatile CharacterCodingException codingException;
    private static final char[] HEX_TABLE = "0123456789ABCDEF".toCharArray();

    public AbstractImmutableRawValue(byte[] data) {
        this.data = data;
    }

    public AbstractImmutableRawValue(String string) {
        this.decodedStringCache = string;
        this.data = string.getBytes(MessagePack.UTF8);
    }

    @Override
    public ImmutableRawValue asRawValue() {
        return this;
    }

    @Override
    public byte[] asByteArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    @Override
    public String asString() {
        if (this.decodedStringCache == null) {
            this.decodeString();
        }
        if (this.codingException != null) {
            throw new MessageStringCodingException(this.codingException);
        }
        return this.decodedStringCache;
    }

    @Override
    public String toJson() {
        StringBuilder sb = new StringBuilder();
        AbstractImmutableRawValue.appendJsonString(sb, this.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeString() {
        byte[] byArray = this.data;
        synchronized (this.data) {
            if (this.decodedStringCache != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                CharsetDecoder reportDecoder = MessagePack.UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                this.decodedStringCache = reportDecoder.decode(this.asByteBuffer()).toString();
            }
            catch (CharacterCodingException ex) {
                try {
                    CharsetDecoder replaceDecoder = MessagePack.UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    this.decodedStringCache = replaceDecoder.decode(this.asByteBuffer()).toString();
                }
                catch (CharacterCodingException neverThrown) {
                    throw new MessageStringCodingException(neverThrown);
                }
                this.codingException = ex;
            }
            return;
        }
    }

    @Override
    public String toString() {
        if (this.decodedStringCache == null) {
            this.decodeString();
        }
        return this.decodedStringCache;
    }

    static void appendJsonString(StringBuilder sb, String string) {
        sb.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    default: {
                        AbstractImmutableRawValue.escapeChar(sb, ch);
                        break;
                    }
                }
                continue;
            }
            if (ch <= '\u007f') {
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                AbstractImmutableRawValue.escapeChar(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        sb.append("\"");
    }

    private static void escapeChar(StringBuilder sb, int ch) {
        sb.append("\\u");
        sb.append(HEX_TABLE[ch >> 12 & 0xF]);
        sb.append(HEX_TABLE[ch >> 8 & 0xF]);
        sb.append(HEX_TABLE[ch >> 4 & 0xF]);
        sb.append(HEX_TABLE[ch & 0xF]);
    }
}

