/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.core.MessageTypeCastException;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.BinaryValue;
import org.msgpack.value.BooleanValue;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.FloatValue;
import org.msgpack.value.ImmutableArrayValue;
import org.msgpack.value.ImmutableBinaryValue;
import org.msgpack.value.ImmutableBooleanValue;
import org.msgpack.value.ImmutableExtensionValue;
import org.msgpack.value.ImmutableFloatValue;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.ImmutableNilValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.NilValue;
import org.msgpack.value.NumberValue;
import org.msgpack.value.RawValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;
import org.msgpack.value.impl.ImmutableBigIntegerValueImpl;

public class Variable
implements Value {
    private final NilValueAccessor nilAccessor = new NilValueAccessor();
    private final BooleanValueAccessor booleanAccessor = new BooleanValueAccessor();
    private final IntegerValueAccessor integerAccessor = new IntegerValueAccessor();
    private final FloatValueAccessor floatAccessor = new FloatValueAccessor();
    private final BinaryValueAccessor binaryAccessor = new BinaryValueAccessor();
    private final StringValueAccessor stringAccessor = new StringValueAccessor();
    private final ArrayValueAccessor arrayAccessor = new ArrayValueAccessor();
    private final MapValueAccessor mapAccessor = new MapValueAccessor();
    private final ExtensionValueAccessor extensionAccessor = new ExtensionValueAccessor();
    private Type type;
    private long longValue;
    private double doubleValue;
    private Object objectValue;
    private AbstractValueAccessor accessor;
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final long BYTE_MIN = -128L;
    private static final long BYTE_MAX = 127L;
    private static final long SHORT_MIN = -32768L;
    private static final long SHORT_MAX = 32767L;
    private static final long INT_MIN = Integer.MIN_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;

    public Variable() {
        this.setNilValue();
    }

    public Variable setNilValue() {
        this.type = Type.NULL;
        this.accessor = this.nilAccessor;
        return this;
    }

    public Variable setBooleanValue(boolean v) {
        this.type = Type.BOOLEAN;
        this.accessor = this.booleanAccessor;
        this.longValue = v ? 1L : 0L;
        return this;
    }

    public Variable setIntegerValue(long v) {
        this.type = Type.LONG;
        this.accessor = this.integerAccessor;
        this.longValue = v;
        return this;
    }

    public Variable setIntegerValue(BigInteger v) {
        if (0 <= v.compareTo(LONG_MIN) && v.compareTo(LONG_MAX) <= 0) {
            this.type = Type.LONG;
            this.accessor = this.integerAccessor;
            this.longValue = v.longValue();
        } else {
            this.type = Type.BIG_INTEGER;
            this.accessor = this.integerAccessor;
            this.objectValue = v;
        }
        return this;
    }

    public Variable setFloatValue(double v) {
        this.type = Type.DOUBLE;
        this.accessor = this.floatAccessor;
        this.doubleValue = v;
        this.longValue = (long)v;
        return this;
    }

    public Variable setFloatValue(float v) {
        this.type = Type.DOUBLE;
        this.accessor = this.floatAccessor;
        this.longValue = (long)v;
        return this;
    }

    public Variable setBinaryValue(byte[] v) {
        this.type = Type.BYTE_ARRAY;
        this.accessor = this.binaryAccessor;
        this.objectValue = v;
        return this;
    }

    public Variable setStringValue(String v) {
        return this.setStringValue(v.getBytes(MessagePack.UTF8));
    }

    public Variable setStringValue(byte[] v) {
        this.type = Type.RAW_STRING;
        this.accessor = this.stringAccessor;
        this.objectValue = v;
        return this;
    }

    public Variable setArrayValue(List<Value> v) {
        this.type = Type.LIST;
        this.accessor = this.arrayAccessor;
        this.objectValue = v;
        return this;
    }

    public Variable setMapValue(Map<Value, Value> v) {
        this.type = Type.MAP;
        this.accessor = this.mapAccessor;
        this.objectValue = v;
        return this;
    }

    public Variable setExtensionValue(byte type, byte[] data) {
        this.type = Type.EXTENSION;
        this.accessor = this.extensionAccessor;
        this.objectValue = ValueFactory.newExtension(type, data);
        return this;
    }

    @Override
    public ImmutableValue immutableValue() {
        return this.accessor.immutableValue();
    }

    @Override
    public void writeTo(MessagePacker pk) throws IOException {
        this.accessor.writeTo(pk);
    }

    public int hashCode() {
        return this.immutableValue().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.immutableValue().equals(o);
    }

    @Override
    public String toJson() {
        return this.immutableValue().toJson();
    }

    public String toString() {
        return this.immutableValue().toString();
    }

    @Override
    public ValueType getValueType() {
        return this.type.getValueType();
    }

    @Override
    public boolean isNilValue() {
        return this.getValueType().isNilType();
    }

    @Override
    public boolean isBooleanValue() {
        return this.getValueType().isBooleanType();
    }

    @Override
    public boolean isNumberValue() {
        return this.getValueType().isNumberType();
    }

    @Override
    public boolean isIntegerValue() {
        return this.getValueType().isIntegerType();
    }

    @Override
    public boolean isFloatValue() {
        return this.getValueType().isFloatType();
    }

    @Override
    public boolean isRawValue() {
        return this.getValueType().isRawType();
    }

    @Override
    public boolean isBinaryValue() {
        return this.getValueType().isBinaryType();
    }

    @Override
    public boolean isStringValue() {
        return this.getValueType().isStringType();
    }

    @Override
    public boolean isArrayValue() {
        return this.getValueType().isArrayType();
    }

    @Override
    public boolean isMapValue() {
        return this.getValueType().isMapType();
    }

    @Override
    public boolean isExtensionValue() {
        return this.getValueType().isExtensionType();
    }

    @Override
    public NilValue asNilValue() {
        if (!this.isNilValue()) {
            throw new MessageTypeCastException();
        }
        return (NilValue)((Object)this.accessor);
    }

    @Override
    public BooleanValue asBooleanValue() {
        if (!this.isBooleanValue()) {
            throw new MessageTypeCastException();
        }
        return (BooleanValue)((Object)this.accessor);
    }

    @Override
    public NumberValue asNumberValue() {
        if (!this.isNumberValue()) {
            throw new MessageTypeCastException();
        }
        return (NumberValue)((Object)this.accessor);
    }

    @Override
    public IntegerValue asIntegerValue() {
        if (!this.isIntegerValue()) {
            throw new MessageTypeCastException();
        }
        return (IntegerValue)((Object)this.accessor);
    }

    @Override
    public FloatValue asFloatValue() {
        if (!this.isFloatValue()) {
            throw new MessageTypeCastException();
        }
        return (FloatValue)((Object)this.accessor);
    }

    @Override
    public RawValue asRawValue() {
        if (!this.isRawValue()) {
            throw new MessageTypeCastException();
        }
        return (RawValue)((Object)this.accessor);
    }

    @Override
    public BinaryValue asBinaryValue() {
        if (!this.isBinaryValue()) {
            throw new MessageTypeCastException();
        }
        return (BinaryValue)((Object)this.accessor);
    }

    @Override
    public StringValue asStringValue() {
        if (!this.isStringValue()) {
            throw new MessageTypeCastException();
        }
        return (StringValue)((Object)this.accessor);
    }

    @Override
    public ArrayValue asArrayValue() {
        if (!this.isArrayValue()) {
            throw new MessageTypeCastException();
        }
        return (ArrayValue)((Object)this.accessor);
    }

    @Override
    public MapValue asMapValue() {
        if (!this.isMapValue()) {
            throw new MessageTypeCastException();
        }
        return (MapValue)((Object)this.accessor);
    }

    @Override
    public ExtensionValue asExtensionValue() {
        if (!this.isExtensionValue()) {
            throw new MessageTypeCastException();
        }
        return (ExtensionValue)((Object)this.accessor);
    }

    private class ExtensionValueAccessor
    extends AbstractValueAccessor
    implements ExtensionValue {
        private ExtensionValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.EXTENSION;
        }

        @Override
        public ExtensionValue asExtensionValue() {
            return this;
        }

        @Override
        public ImmutableExtensionValue immutableValue() {
            return (ImmutableExtensionValue)Variable.this.objectValue;
        }

        @Override
        public byte getType() {
            return ((ImmutableExtensionValue)Variable.this.objectValue).getType();
        }

        @Override
        public byte[] getData() {
            return ((ImmutableExtensionValue)Variable.this.objectValue).getData();
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            ((ImmutableExtensionValue)Variable.this.objectValue).writeTo(pk);
        }
    }

    private class MapValueAccessor
    extends AbstractValueAccessor
    implements MapValue {
        private MapValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.MAP;
        }

        @Override
        public MapValue asMapValue() {
            return this;
        }

        @Override
        public ImmutableMapValue immutableValue() {
            return ValueFactory.newMap(this.map());
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public Set<Value> keySet() {
            return this.map().keySet();
        }

        @Override
        public Set<Map.Entry<Value, Value>> entrySet() {
            return this.map().entrySet();
        }

        @Override
        public Collection<Value> values() {
            return this.map().values();
        }

        @Override
        public Value[] getKeyValueArray() {
            Map<Value, Value> v = this.map();
            Value[] kvs = new Value[v.size() * 2];
            Iterator<Map.Entry<Value, Value>> ite = v.entrySet().iterator();
            int i = 0;
            while (ite.hasNext()) {
                Map.Entry<Value, Value> pair = ite.next();
                kvs[i] = pair.getKey();
                kvs[++i] = pair.getValue();
                ++i;
            }
            return kvs;
        }

        @Override
        public Map<Value, Value> map() {
            return (Map)Variable.this.objectValue;
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            Map<Value, Value> m = this.map();
            pk.packArrayHeader(m.size());
            for (Map.Entry<Value, Value> pair : m.entrySet()) {
                pair.getKey().writeTo(pk);
                pair.getValue().writeTo(pk);
            }
        }
    }

    private class ArrayValueAccessor
    extends AbstractValueAccessor
    implements ArrayValue {
        private ArrayValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.ARRAY;
        }

        @Override
        public ArrayValue asArrayValue() {
            return this;
        }

        @Override
        public ImmutableArrayValue immutableValue() {
            return ValueFactory.newArray(this.list());
        }

        @Override
        public int size() {
            return this.list().size();
        }

        @Override
        public Value get(int index) {
            return this.list().get(index);
        }

        @Override
        public Value getOrNilValue(int index) {
            List<Value> l = this.list();
            if (l.size() < index && index >= 0) {
                return ValueFactory.newNil();
            }
            return l.get(index);
        }

        @Override
        public Iterator<Value> iterator() {
            return this.list().iterator();
        }

        @Override
        public List<Value> list() {
            return (List)Variable.this.objectValue;
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            List<Value> l = this.list();
            pk.packArrayHeader(l.size());
            for (Value e : l) {
                e.writeTo(pk);
            }
        }
    }

    private class StringValueAccessor
    extends AbstractRawValueAccessor
    implements StringValue {
        private StringValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.STRING;
        }

        @Override
        public StringValue asStringValue() {
            return this;
        }

        @Override
        public ImmutableStringValue immutableValue() {
            return ValueFactory.newString((byte[])Variable.this.objectValue);
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            byte[] data = (byte[])Variable.this.objectValue;
            pk.packRawStringHeader(data.length);
            pk.writePayload(data);
        }
    }

    private class BinaryValueAccessor
    extends AbstractRawValueAccessor
    implements BinaryValue {
        private BinaryValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.BINARY;
        }

        @Override
        public BinaryValue asBinaryValue() {
            return this;
        }

        @Override
        public ImmutableBinaryValue immutableValue() {
            return ValueFactory.newBinary(this.asByteArray());
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            byte[] data = (byte[])Variable.this.objectValue;
            pk.packBinaryHeader(data.length);
            pk.writePayload(data);
        }
    }

    private abstract class AbstractRawValueAccessor
    extends AbstractValueAccessor
    implements RawValue {
        private AbstractRawValueAccessor() {
        }

        @Override
        public RawValue asRawValue() {
            return this;
        }

        @Override
        public byte[] asByteArray() {
            return (byte[])Variable.this.objectValue;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return ByteBuffer.wrap(this.asByteArray());
        }

        @Override
        public String asString() {
            byte[] raw = (byte[])Variable.this.objectValue;
            try {
                CharsetDecoder reportDecoder = MessagePack.UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                return reportDecoder.decode(ByteBuffer.wrap(raw)).toString();
            }
            catch (CharacterCodingException ex) {
                throw new MessageStringCodingException(ex);
            }
        }

        @Override
        public String toString() {
            byte[] raw = (byte[])Variable.this.objectValue;
            try {
                CharsetDecoder reportDecoder = MessagePack.UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                return reportDecoder.decode(ByteBuffer.wrap(raw)).toString();
            }
            catch (CharacterCodingException ex) {
                throw new MessageStringCodingException(ex);
            }
        }
    }

    private class FloatValueAccessor
    extends AbstractNumberValueAccessor
    implements FloatValue {
        private FloatValueAccessor() {
        }

        @Override
        public FloatValue asFloatValue() {
            return this;
        }

        @Override
        public ImmutableFloatValue immutableValue() {
            return ValueFactory.newFloat(Variable.this.doubleValue);
        }

        @Override
        public ValueType getValueType() {
            return ValueType.FLOAT;
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            pk.packDouble(Variable.this.doubleValue);
        }
    }

    private class IntegerValueAccessor
    extends AbstractNumberValueAccessor
    implements IntegerValue {
        private IntegerValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.INTEGER;
        }

        @Override
        public IntegerValue asIntegerValue() {
            return this;
        }

        @Override
        public ImmutableIntegerValue immutableValue() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ValueFactory.newInteger((BigInteger)Variable.this.objectValue);
            }
            return ValueFactory.newInteger(Variable.this.longValue);
        }

        @Override
        public boolean isInByteRange() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return false;
            }
            return -128L <= Variable.this.longValue && Variable.this.longValue <= 127L;
        }

        @Override
        public boolean isInShortRange() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return false;
            }
            return -32768L <= Variable.this.longValue && Variable.this.longValue <= 32767L;
        }

        @Override
        public boolean isInIntRange() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return false;
            }
            return Integer.MIN_VALUE <= Variable.this.longValue && Variable.this.longValue <= Integer.MAX_VALUE;
        }

        @Override
        public boolean isInLongRange() {
            return Variable.this.type != Type.BIG_INTEGER;
        }

        @Override
        public MessageFormat mostSuccinctMessageFormat() {
            return ImmutableBigIntegerValueImpl.mostSuccinctMessageFormat(this);
        }

        @Override
        public byte asByte() {
            if (!this.isInByteRange()) {
                throw new MessageIntegerOverflowException(Variable.this.longValue);
            }
            return (byte)Variable.this.longValue;
        }

        @Override
        public short asShort() {
            if (!this.isInByteRange()) {
                throw new MessageIntegerOverflowException(Variable.this.longValue);
            }
            return (short)Variable.this.longValue;
        }

        @Override
        public int asInt() {
            if (!this.isInIntRange()) {
                throw new MessageIntegerOverflowException(Variable.this.longValue);
            }
            return (int)Variable.this.longValue;
        }

        @Override
        public long asLong() {
            if (!this.isInLongRange()) {
                throw new MessageIntegerOverflowException(Variable.this.longValue);
            }
            return Variable.this.longValue;
        }

        @Override
        public BigInteger asBigInteger() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return (BigInteger)Variable.this.objectValue;
            }
            return BigInteger.valueOf(Variable.this.longValue);
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            if (Variable.this.type == Type.BIG_INTEGER) {
                pk.packBigInteger((BigInteger)Variable.this.objectValue);
            } else {
                pk.packLong(Variable.this.longValue);
            }
        }
    }

    private abstract class AbstractNumberValueAccessor
    extends AbstractValueAccessor
    implements NumberValue {
        private AbstractNumberValueAccessor() {
        }

        @Override
        public NumberValue asNumberValue() {
            return this;
        }

        @Override
        public byte toByte() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).byteValue();
            }
            return (byte)Variable.this.longValue;
        }

        @Override
        public short toShort() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).shortValue();
            }
            return (short)Variable.this.longValue;
        }

        @Override
        public int toInt() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).intValue();
            }
            return (int)Variable.this.longValue;
        }

        @Override
        public long toLong() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).longValue();
            }
            return Variable.this.longValue;
        }

        @Override
        public BigInteger toBigInteger() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return (BigInteger)Variable.this.objectValue;
            }
            if (Variable.this.type == Type.DOUBLE) {
                return new BigDecimal(Variable.this.doubleValue).toBigInteger();
            }
            return BigInteger.valueOf(Variable.this.longValue);
        }

        @Override
        public float toFloat() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).floatValue();
            }
            if (Variable.this.type == Type.DOUBLE) {
                return (float)Variable.this.doubleValue;
            }
            return Variable.this.longValue;
        }

        @Override
        public double toDouble() {
            if (Variable.this.type == Type.BIG_INTEGER) {
                return ((BigInteger)Variable.this.objectValue).doubleValue();
            }
            if (Variable.this.type == Type.DOUBLE) {
                return Variable.this.doubleValue;
            }
            return Variable.this.longValue;
        }
    }

    private class BooleanValueAccessor
    extends AbstractValueAccessor
    implements BooleanValue {
        private BooleanValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.BOOLEAN;
        }

        @Override
        public BooleanValue asBooleanValue() {
            return this;
        }

        @Override
        public ImmutableBooleanValue immutableValue() {
            return ValueFactory.newBoolean(this.getBoolean());
        }

        @Override
        public boolean getBoolean() {
            return Variable.this.longValue == 1L;
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            pk.packBoolean(Variable.this.longValue == 1L);
        }
    }

    private class NilValueAccessor
    extends AbstractValueAccessor
    implements NilValue {
        private NilValueAccessor() {
        }

        @Override
        public ValueType getValueType() {
            return ValueType.NIL;
        }

        @Override
        public NilValue asNilValue() {
            return this;
        }

        @Override
        public ImmutableNilValue immutableValue() {
            return ValueFactory.newNil();
        }

        @Override
        public void writeTo(MessagePacker pk) throws IOException {
            pk.packNil();
        }
    }

    public static enum Type {
        NULL(ValueType.NIL),
        BOOLEAN(ValueType.BOOLEAN),
        LONG(ValueType.INTEGER),
        BIG_INTEGER(ValueType.INTEGER),
        DOUBLE(ValueType.FLOAT),
        BYTE_ARRAY(ValueType.BINARY),
        RAW_STRING(ValueType.STRING),
        LIST(ValueType.ARRAY),
        MAP(ValueType.MAP),
        EXTENSION(ValueType.EXTENSION);

        private final ValueType valueType;

        private Type(ValueType valueType) {
            this.valueType = valueType;
        }

        public ValueType getValueType() {
            return this.valueType;
        }
    }

    private abstract class AbstractValueAccessor
    implements Value {
        private AbstractValueAccessor() {
        }

        @Override
        public boolean isNilValue() {
            return this.getValueType().isNilType();
        }

        @Override
        public boolean isBooleanValue() {
            return this.getValueType().isBooleanType();
        }

        @Override
        public boolean isNumberValue() {
            return this.getValueType().isNumberType();
        }

        @Override
        public boolean isIntegerValue() {
            return this.getValueType().isIntegerType();
        }

        @Override
        public boolean isFloatValue() {
            return this.getValueType().isFloatType();
        }

        @Override
        public boolean isRawValue() {
            return this.getValueType().isRawType();
        }

        @Override
        public boolean isBinaryValue() {
            return this.getValueType().isBinaryType();
        }

        @Override
        public boolean isStringValue() {
            return this.getValueType().isStringType();
        }

        @Override
        public boolean isArrayValue() {
            return this.getValueType().isArrayType();
        }

        @Override
        public boolean isMapValue() {
            return this.getValueType().isMapType();
        }

        @Override
        public boolean isExtensionValue() {
            return this.getValueType().isExtensionType();
        }

        @Override
        public NilValue asNilValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public BooleanValue asBooleanValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public NumberValue asNumberValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public IntegerValue asIntegerValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public FloatValue asFloatValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public RawValue asRawValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public BinaryValue asBinaryValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public StringValue asStringValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public ArrayValue asArrayValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public MapValue asMapValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public ExtensionValue asExtensionValue() {
            throw new MessageTypeCastException();
        }

        @Override
        public boolean equals(Object obj) {
            return Variable.this.equals(obj);
        }

        public int hashCode() {
            return Variable.this.hashCode();
        }

        @Override
        public String toJson() {
            return Variable.this.toJson();
        }

        public String toString() {
            return Variable.this.toString();
        }
    }
}

