/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class InputStreamBufferInput
implements MessageBufferInput {
    private InputStream in;
    private final byte[] buffer;

    public static MessageBufferInput newBufferInput(InputStream in) {
        FileChannel channel;
        Preconditions.checkNotNull(in, "InputStream is null");
        if (in instanceof FileInputStream && (channel = ((FileInputStream)in).getChannel()) != null) {
            return new ChannelBufferInput(channel);
        }
        return new InputStreamBufferInput(in);
    }

    public InputStreamBufferInput(InputStream in) {
        this(in, 8192);
    }

    public InputStreamBufferInput(InputStream in, int bufferSize) {
        this.in = Preconditions.checkNotNull(in, "input is null");
        this.buffer = new byte[bufferSize];
    }

    public InputStream reset(InputStream in) throws IOException {
        InputStream old = this.in;
        this.in = in;
        return old;
    }

    @Override
    public MessageBuffer next() throws IOException {
        int readLen = this.in.read(this.buffer);
        if (readLen == -1) {
            return null;
        }
        return MessageBuffer.wrap(this.buffer, 0, readLen);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

