/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.ByteBufferInput;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.ChannelBufferOutput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;

public class MessagePack {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final PackerConfig DEFAULT_PACKER_CONFIG = new PackerConfig();
    public static final UnpackerConfig DEFAULT_UNPACKER_CONFIG = new UnpackerConfig();

    private MessagePack() {
    }

    public static MessagePacker newDefaultPacker(MessageBufferOutput out) {
        return DEFAULT_PACKER_CONFIG.newPacker(out);
    }

    public static MessagePacker newDefaultPacker(OutputStream out) {
        return DEFAULT_PACKER_CONFIG.newPacker(out);
    }

    public static MessagePacker newDefaultPacker(WritableByteChannel channel) {
        return DEFAULT_PACKER_CONFIG.newPacker(channel);
    }

    public static MessageBufferPacker newDefaultBufferPacker() {
        return DEFAULT_PACKER_CONFIG.newBufferPacker();
    }

    public static MessageUnpacker newDefaultUnpacker(MessageBufferInput in) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(in);
    }

    public static MessageUnpacker newDefaultUnpacker(InputStream in) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(in);
    }

    public static MessageUnpacker newDefaultUnpacker(ReadableByteChannel channel) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(channel);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] contents) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(contents);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] contents, int offset, int length) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(contents, offset, length);
    }

    public static MessageUnpacker newDefaultUnpacker(ByteBuffer contents) {
        return DEFAULT_UNPACKER_CONFIG.newUnpacker(contents);
    }

    public static class UnpackerConfig
    implements Cloneable {
        private boolean allowReadingStringAsBinary = true;
        private boolean allowReadingBinaryAsString = true;
        private CodingErrorAction actionOnMalformedString = CodingErrorAction.REPLACE;
        private CodingErrorAction actionOnUnmappableString = CodingErrorAction.REPLACE;
        private int stringSizeLimit = Integer.MAX_VALUE;
        private int bufferSize = 8192;
        private int stringDecoderBufferSize = 8192;

        public UnpackerConfig() {
        }

        private UnpackerConfig(UnpackerConfig copy) {
            this.allowReadingStringAsBinary = copy.allowReadingStringAsBinary;
            this.allowReadingBinaryAsString = copy.allowReadingBinaryAsString;
            this.actionOnMalformedString = copy.actionOnMalformedString;
            this.actionOnUnmappableString = copy.actionOnUnmappableString;
            this.stringSizeLimit = copy.stringSizeLimit;
            this.bufferSize = copy.bufferSize;
        }

        public UnpackerConfig clone() {
            return new UnpackerConfig(this);
        }

        public int hashCode() {
            int result = this.allowReadingStringAsBinary ? 1 : 0;
            result = 31 * result + (this.allowReadingBinaryAsString ? 1 : 0);
            result = 31 * result + (this.actionOnMalformedString != null ? this.actionOnMalformedString.hashCode() : 0);
            result = 31 * result + (this.actionOnUnmappableString != null ? this.actionOnUnmappableString.hashCode() : 0);
            result = 31 * result + this.stringSizeLimit;
            result = 31 * result + this.bufferSize;
            result = 31 * result + this.stringDecoderBufferSize;
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnpackerConfig)) {
                return false;
            }
            UnpackerConfig o = (UnpackerConfig)obj;
            return this.allowReadingStringAsBinary == o.allowReadingStringAsBinary && this.allowReadingBinaryAsString == o.allowReadingBinaryAsString && this.actionOnMalformedString == o.actionOnMalformedString && this.actionOnUnmappableString == o.actionOnUnmappableString && this.stringSizeLimit == o.stringSizeLimit && this.stringDecoderBufferSize == o.stringDecoderBufferSize && this.bufferSize == o.bufferSize;
        }

        public MessageUnpacker newUnpacker(MessageBufferInput in) {
            return new MessageUnpacker(in, this);
        }

        public MessageUnpacker newUnpacker(InputStream in) {
            return this.newUnpacker(new InputStreamBufferInput(in, this.bufferSize));
        }

        public MessageUnpacker newUnpacker(ReadableByteChannel channel) {
            return this.newUnpacker(new ChannelBufferInput(channel, this.bufferSize));
        }

        public MessageUnpacker newUnpacker(byte[] contents) {
            return this.newUnpacker(new ArrayBufferInput(contents));
        }

        public MessageUnpacker newUnpacker(byte[] contents, int offset, int length) {
            return this.newUnpacker(new ArrayBufferInput(contents, offset, length));
        }

        public MessageUnpacker newUnpacker(ByteBuffer contents) {
            return this.newUnpacker(new ByteBufferInput(contents));
        }

        public UnpackerConfig withAllowReadingStringAsBinary(boolean enable) {
            UnpackerConfig copy = this.clone();
            copy.allowReadingStringAsBinary = enable;
            return copy;
        }

        public boolean getAllowReadingStringAsBinary() {
            return this.allowReadingStringAsBinary;
        }

        public UnpackerConfig withAllowReadingBinaryAsString(boolean enable) {
            UnpackerConfig copy = this.clone();
            copy.allowReadingBinaryAsString = enable;
            return copy;
        }

        public boolean getAllowReadingBinaryAsString() {
            return this.allowReadingBinaryAsString;
        }

        public UnpackerConfig withActionOnMalformedString(CodingErrorAction action) {
            UnpackerConfig copy = this.clone();
            copy.actionOnMalformedString = action;
            return copy;
        }

        public CodingErrorAction getActionOnMalformedString() {
            return this.actionOnMalformedString;
        }

        public UnpackerConfig withActionOnUnmappableString(CodingErrorAction action) {
            UnpackerConfig copy = this.clone();
            copy.actionOnUnmappableString = action;
            return copy;
        }

        public CodingErrorAction getActionOnUnmappableString() {
            return this.actionOnUnmappableString;
        }

        public UnpackerConfig withStringSizeLimit(int bytes) {
            UnpackerConfig copy = this.clone();
            copy.stringSizeLimit = bytes;
            return copy;
        }

        public int getStringSizeLimit() {
            return this.stringSizeLimit;
        }

        public UnpackerConfig withStringDecoderBufferSize(int bytes) {
            UnpackerConfig copy = this.clone();
            copy.stringDecoderBufferSize = bytes;
            return copy;
        }

        public int getStringDecoderBufferSize() {
            return this.stringDecoderBufferSize;
        }

        public UnpackerConfig withBufferSize(int bytes) {
            UnpackerConfig copy = this.clone();
            copy.bufferSize = bytes;
            return copy;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }
    }

    public static class PackerConfig
    implements Cloneable {
        private int smallStringOptimizationThreshold = 512;
        private int bufferFlushThreshold = 8192;
        private int bufferSize = 8192;
        private boolean str8FormatSupport = true;

        public PackerConfig() {
        }

        private PackerConfig(PackerConfig copy) {
            this.smallStringOptimizationThreshold = copy.smallStringOptimizationThreshold;
            this.bufferFlushThreshold = copy.bufferFlushThreshold;
            this.bufferSize = copy.bufferSize;
            this.str8FormatSupport = copy.str8FormatSupport;
        }

        public PackerConfig clone() {
            return new PackerConfig(this);
        }

        public int hashCode() {
            int result = this.smallStringOptimizationThreshold;
            result = 31 * result + this.bufferFlushThreshold;
            result = 31 * result + this.bufferSize;
            result = 31 * result + (this.str8FormatSupport ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PackerConfig)) {
                return false;
            }
            PackerConfig o = (PackerConfig)obj;
            return this.smallStringOptimizationThreshold == o.smallStringOptimizationThreshold && this.bufferFlushThreshold == o.bufferFlushThreshold && this.bufferSize == o.bufferSize && this.str8FormatSupport == o.str8FormatSupport;
        }

        public MessagePacker newPacker(MessageBufferOutput out) {
            return new MessagePacker(out, this);
        }

        public MessagePacker newPacker(OutputStream out) {
            return this.newPacker(new OutputStreamBufferOutput(out, this.bufferSize));
        }

        public MessagePacker newPacker(WritableByteChannel channel) {
            return this.newPacker(new ChannelBufferOutput(channel, this.bufferSize));
        }

        public MessageBufferPacker newBufferPacker() {
            return new MessageBufferPacker(this);
        }

        public PackerConfig withSmallStringOptimizationThreshold(int length) {
            PackerConfig copy = this.clone();
            copy.smallStringOptimizationThreshold = length;
            return copy;
        }

        public int getSmallStringOptimizationThreshold() {
            return this.smallStringOptimizationThreshold;
        }

        public PackerConfig withBufferFlushThreshold(int bytes) {
            PackerConfig copy = this.clone();
            copy.bufferFlushThreshold = bytes;
            return copy;
        }

        public int getBufferFlushThreshold() {
            return this.bufferFlushThreshold;
        }

        public PackerConfig withBufferSize(int bytes) {
            PackerConfig copy = this.clone();
            copy.bufferSize = bytes;
            return copy;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public PackerConfig withStr8FormatSupport(boolean str8FormatSupport) {
            PackerConfig copy = this.clone();
            copy.str8FormatSupport = str8FormatSupport;
            return copy;
        }

        public boolean isStr8FormatSupport() {
            return this.str8FormatSupport;
        }
    }

    public static final class Code {
        public static final byte POSFIXINT_MASK = -128;
        public static final byte FIXMAP_PREFIX = -128;
        public static final byte FIXARRAY_PREFIX = -112;
        public static final byte FIXSTR_PREFIX = -96;
        public static final byte NIL = -64;
        public static final byte NEVER_USED = -63;
        public static final byte FALSE = -62;
        public static final byte TRUE = -61;
        public static final byte BIN8 = -60;
        public static final byte BIN16 = -59;
        public static final byte BIN32 = -58;
        public static final byte EXT8 = -57;
        public static final byte EXT16 = -56;
        public static final byte EXT32 = -55;
        public static final byte FLOAT32 = -54;
        public static final byte FLOAT64 = -53;
        public static final byte UINT8 = -52;
        public static final byte UINT16 = -51;
        public static final byte UINT32 = -50;
        public static final byte UINT64 = -49;
        public static final byte INT8 = -48;
        public static final byte INT16 = -47;
        public static final byte INT32 = -46;
        public static final byte INT64 = -45;
        public static final byte FIXEXT1 = -44;
        public static final byte FIXEXT2 = -43;
        public static final byte FIXEXT4 = -42;
        public static final byte FIXEXT8 = -41;
        public static final byte FIXEXT16 = -40;
        public static final byte STR8 = -39;
        public static final byte STR16 = -38;
        public static final byte STR32 = -37;
        public static final byte ARRAY16 = -36;
        public static final byte ARRAY32 = -35;
        public static final byte MAP16 = -34;
        public static final byte MAP32 = -33;
        public static final byte NEGFIXINT_PREFIX = -32;

        public static final boolean isFixInt(byte b) {
            int v = b & 0xFF;
            return v <= 127 || v >= 224;
        }

        public static final boolean isPosFixInt(byte b) {
            return (b & 0xFFFFFF80) == 0;
        }

        public static final boolean isNegFixInt(byte b) {
            return (b & 0xFFFFFFE0) == -32;
        }

        public static final boolean isFixStr(byte b) {
            return (b & 0xFFFFFFE0) == -96;
        }

        public static final boolean isFixedArray(byte b) {
            return (b & 0xFFFFFFF0) == -112;
        }

        public static final boolean isFixedMap(byte b) {
            return (b & 0xFFFFFFF0) == -128;
        }

        public static final boolean isFixedRaw(byte b) {
            return (b & 0xFFFFFFE0) == -96;
        }
    }
}

