/*
 * Decompiled with CFR 0.152.
 */
package nianshow.statusbar.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nianshow.statusbar.config.ConfigCache;
import nianshow.statusbar.entity.DamageNumber;
import nianshow.statusbar.gui.ObjectiveUi;

public class StatusUi
extends Gui {
    public static final Minecraft GAME = Minecraft.func_71410_x();
    public static final ResourceLocation TEX = new ResourceLocation("statusbar:textures/statusbar.png");
    public static float nowMagic;
    public static float maxMagic;
    public static float level;
    public static float nowExp;
    public static float maxExp;
    public static boolean visible;

    @SubscribeEvent
    public void onRender(RenderLivingEvent.Post<?> e) {
        boolean flag2;
        EntityLivingBase entity = e.getEntity();
        String entityName = entity.func_70005_c_();
        boolean flag1 = entity.equals((Object)StatusUi.GAME.field_71439_g) || entity instanceof EntityArmorStand || entity instanceof DamageNumber;
        boolean bl = flag2 = entityName.startsWith("[sb]") || entityName.startsWith("[HIT_BOX]") || entity.func_110143_aJ() == entity.func_110138_aP();
        if (!visible || flag1 || flag2) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)e.getX(), (double)e.getY(), (double)e.getZ());
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.field_70131_O + 1.0f), (float)0.0f);
        RenderManager renderManager = e.getRenderer().func_177068_d();
        float viewX = renderManager.field_78732_j;
        float viewY = -renderManager.field_78735_i;
        GlStateManager.func_179114_b((float)viewY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * viewX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-0.0125, (double)-0.0125, (double)0.0125);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderManager.field_78724_e.func_110577_a(TEX);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float scale = 0.001953125f;
        float x = -102.0f;
        float y = 9.0f;
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)(x + 204.0f), (double)(y - 18.0f), -0.5).func_187315_a((double)(scale * 408.0f), (double)(scale * 47.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 204.0f), (double)(y + 0.0f), -0.5).func_187315_a((double)(scale * 408.0f), (double)(scale * 65.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), -0.5).func_187315_a((double)(scale * 204.0f), (double)(scale * 65.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 0.0f), (double)(y - 18.0f), -0.5).func_187315_a((double)(scale * 204.0f), (double)(scale * 47.0f)).func_181675_d();
        float width = Math.min(entity.func_110143_aJ() / entity.func_110138_aP(), 1.0f) * 200.0f;
        builder.func_181662_b((double)(x + 2.0f + width), (double)(y - 1.0f - 16.0f), -0.25).func_187315_a((double)(scale * 404.0f), (double)(scale * 65.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 2.0f + width), (double)(y - 1.0f + 0.0f), -0.25).func_187315_a((double)(scale * 404.0f), (double)(scale * 81.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 2.0f + 0.0f), (double)(y - 1.0f + 0.0f), -0.25).func_187315_a((double)(scale * 204.0f), (double)(scale * 81.0f)).func_181675_d();
        builder.func_181662_b((double)(x + 2.0f + 0.0f), (double)(y - 1.0f - 16.0f), -0.25).func_187315_a((double)(scale * 204.0f), (double)(scale * 65.0f)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        FontRenderer fontRenderer = e.getRenderer().func_76983_a();
        String text = String.format("%d/%d", (long)entity.func_110143_aJ(), (long)entity.func_110138_aP());
        this.func_73732_a(fontRenderer, text, 0, -4, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent e) {
        Entity entity = GAME.func_175606_aa();
        if (entity == null) {
            return;
        }
        double renderPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)e.getPartialTicks();
        double renderPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)e.getPartialTicks();
        double renderPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)e.getPartialTicks();
        for (ObjectiveUi.Content content : new ArrayList<ObjectiveUi.Content>(ObjectiveUi.CONTENTS)) {
            double distance;
            if (!ConfigCache.mark.contains(content.title) || !ObjectiveUi.worldName.equals(content.world)) continue;
            double x = (double)content.x - renderPosX;
            double y = (double)content.y - renderPosY;
            double z = (double)content.z - renderPosZ;
            double scaleDistance = distance = this.getDistanceToEntity(entity, content.x, content.y, content.z);
            double renderDistance = StatusUi.GAME.field_71474_y.func_74296_a(GameSettings.Options.RENDER_DISTANCE) * 16.0f;
            if (distance > renderDistance) {
                x = x / distance * renderDistance;
                y = y / distance * renderDistance;
                z = z / distance * renderDistance;
                scaleDistance = renderDistance;
            }
            float scale = (float)(scaleDistance * 0.1 + 1.0) * 0.025f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            StatusUi.GAME.field_71446_o.func_110577_a(content.mark);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b(-10.0, -10.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            builder.func_181662_b(-10.0, 10.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            builder.func_181662_b(10.0, 10.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            builder.func_181662_b(10.0, -10.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179097_i();
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            builder.func_181662_b(-10.0, -10.0, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.3f).func_181675_d();
            builder.func_181662_b(-10.0, 10.0, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.3f).func_181675_d();
            builder.func_181662_b(10.0, 10.0, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.3f).func_181675_d();
            builder.func_181662_b(10.0, -10.0, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.3f).func_181675_d();
            tessellator.func_78381_a();
            String text = String.format("%s (%dm)\u00a7r", content.title, (int)distance);
            StatusUi.GAME.field_71466_p.func_175065_a(text, -((float)StatusUi.GAME.field_71466_p.func_78256_a(text) / 2.0f), -20.0f, 0xFFFFFF, false);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre e) {
        if (!visible) {
            return;
        }
        switch (e.getType()) {
            case HOTBAR: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179137_b((double)(e.getResolution().func_78327_c() / 2.0 - 118.0), (double)(e.getResolution().func_78324_d() - 43.0), (double)0.0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                this.drawHealthBar();
                this.drawMagicBar();
                this.drawExperienceBar();
                this.drawDone();
                GlStateManager.func_179121_F();
                return;
            }
            case HEALTH: 
            case ARMOR: 
            case FOOD: 
            case AIR: 
            case EXPERIENCE: {
                e.setCanceled(true);
                return;
            }
        }
    }

    private void drawHealthBar() {
        StatusUi.GAME.field_71446_o.func_110577_a(TEX);
        StatusUi.func_146110_a((int)12, (int)6, (float)0.0f, (float)47.0f, (int)204, (int)18, (float)512.0f, (float)512.0f);
        float absorption = StatusUi.GAME.field_71439_g.func_110139_bj();
        float health = StatusUi.GAME.field_71439_g.func_110143_aJ();
        float maxHealth = StatusUi.GAME.field_71439_g.func_110138_aP();
        int width = (int)(204.0f * Math.min(health / (maxHealth + absorption), 1.0f));
        int u = 204 - width;
        int x = 204 - width + 12;
        StatusUi.func_146110_a((int)x, (int)6, (float)u, (float)65.0f, (int)width, (int)18, (float)512.0f, (float)512.0f);
        String text = String.format("%d/%d", (int)health, (int)maxHealth);
        this.drawText(207 - text.length() * 10, 9, false, text);
        if (absorption > 0.0f) {
            width = 204 - width;
            StatusUi.func_146110_a((int)(x - width), (int)6, (float)0.0f, (float)83.0f, (int)width, (int)18, (float)512.0f, (float)512.0f);
            text = String.format("%d", (int)absorption);
            this.drawText(x - width + width / 2, 9, true, text);
        }
    }

    private void drawMagicBar() {
        StatusUi.GAME.field_71446_o.func_110577_a(TEX);
        StatusUi.func_146110_a((int)255, (int)6, (float)0.0f, (float)101.0f, (int)204, (int)18, (float)512.0f, (float)512.0f);
        float scale = Math.min(nowMagic / maxMagic, 1.0f);
        StatusUi.func_146110_a((int)255, (int)6, (float)0.0f, (float)119.0f, (int)((int)(204.0f * scale)), (int)18, (float)512.0f, (float)512.0f);
        this.drawText(260, 9, false, String.format("%d/%d", (int)nowMagic, (int)maxMagic));
    }

    private void drawExperienceBar() {
        StatusUi.GAME.field_71446_o.func_110577_a(TEX);
        StatusUi.func_146110_a((int)15, (int)30, (float)0.0f, (float)39.0f, (int)443, (int)4, (float)512.0f, (float)512.0f);
        float scale = Math.min(nowExp / maxExp, 1.0f);
        StatusUi.func_146110_a((int)15, (int)30, (float)0.0f, (float)43.0f, (int)((int)(443.0f * scale)), (int)4, (float)512.0f, (float)512.0f);
        this.drawText(236, 25, true, String.format("%d/%d", (int)nowExp, (int)maxExp));
        this.drawText(236, 10, true, String.format("%d", (int)level));
    }

    private void drawDone() {
        StatusUi.GAME.field_71446_o.func_110577_a(TEX);
        StatusUi.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)472, (int)39, (float)512.0f, (float)512.0f);
    }

    private void drawText(int x, int y, boolean center, String text) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(center ? (float)(x - text.length() * 5) : (float)x), (float)y, (float)1.0f);
        for (int i = 0; i < text.length(); ++i) {
            this.drawFont(text.charAt(i));
            GlStateManager.func_179109_b((float)10.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179121_F();
    }

    private void drawFont(char font) {
        int u;
        switch (font) {
            case '0': {
                u = 0;
                break;
            }
            case '1': {
                u = 12;
                break;
            }
            case '2': {
                u = 24;
                break;
            }
            case '3': {
                u = 36;
                break;
            }
            case '4': {
                u = 48;
                break;
            }
            case '5': {
                u = 60;
                break;
            }
            case '6': {
                u = 72;
                break;
            }
            case '7': {
                u = 84;
                break;
            }
            case '8': {
                u = 96;
                break;
            }
            case '9': {
                u = 108;
                break;
            }
            case '/': {
                u = 120;
                break;
            }
            default: {
                return;
            }
        }
        StatusUi.GAME.field_71446_o.func_110577_a(TEX);
        StatusUi.func_146110_a((int)0, (int)0, (float)u, (float)137.0f, (int)12, (int)12, (float)512.0f, (float)512.0f);
    }

    private double getDistanceToEntity(Entity entity, int x, int y, int z) {
        double deltaX = entity.field_70165_t - (double)x;
        double deltaY = entity.field_70163_u - (double)y;
        double deltaZ = entity.field_70161_v - (double)z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }
}

