/*
 * Decompiled with CFR 0.152.
 */
package nianshow.statusbar.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import nianshow.statusbar.config.ConfigCache;

public class ObjectiveUi
extends GuiScreen {
    public static final ResourceLocation TEX = new ResourceLocation("statusbar:textures/objective.png");
    public static final List<Content> CONTENTS = new ArrayList<Content>();
    public static String worldName;
    private int x;
    private int y;
    private Scroll scroll;
    private Button button;

    public void func_73866_w_() {
        this.x = (this.field_146294_l - 385) / 2;
        this.y = (this.field_146295_m - 225) / 2;
        if (!CONTENTS.isEmpty()) {
            this.scroll = new Scroll(this.field_146297_k, 151, this.y + 6, this.y + 6 + 213, this.x + 5, 24, this.field_146294_l, this.field_146295_m);
            this.button = (Button)this.func_189646_b(new Button(0, this.x + 201, this.y + 199, ""));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        try {
            this.func_146276_q_();
            this.field_146297_k.field_71446_o.func_110577_a(TEX);
            ObjectiveUi.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)385, (int)225, (float)512.0f, (float)512.0f);
            if (!CONTENTS.isEmpty() && this.scroll != null) {
                this.scroll.drawScreen(mouseX, mouseY, ticks);
                Content content = CONTENTS.get(Math.max(this.scroll.select, 0));
                this.func_73732_a(this.field_146289_q, content.title + "\u00a7r", this.x + 268, this.y + 10, 0xFFFFFF);
                GlStateManager.func_179094_E();
                for (String text : content.text.split("\n")) {
                    this.field_146289_q.func_175063_a(text, (float)(this.x + 166), (float)(this.y + 25), 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)this.field_146289_q.field_78288_b, (float)0.0f);
                }
                GlStateManager.func_179121_F();
                this.button.field_146126_j = content.traceable ? "\u00a74\u65e0\u6cd5\u8ffd\u8e2a\u00a7r" : (ConfigCache.mark.contains(content.title) ? "\u00a7c\u53d6\u6d88\u8ffd\u8e2a\u00a7r" : "\u8ffd\u8e2a\u76ee\u6807");
                super.func_73863_a(mouseX, mouseY, ticks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_146284_a(GuiButton button) {
        if (button.equals((Object)this.button) && !button.field_146126_j.startsWith("\u00a74")) {
            Content content = CONTENTS.get(Math.max(this.scroll.select, 0));
            if (ConfigCache.mark.contains(content.title)) {
                ConfigCache.mark.remove(content.title);
            } else {
                ConfigCache.mark.add(content.title);
            }
            ConfigCache.save();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public static void drawRectWith9Slice(int x, int y, int u, int v, int width, int height, int finalWidth, int finalHeight, float textureWidth, float textureHeight, int ... slice) {
        int right;
        int left;
        int bottom;
        int top;
        if (slice.length == 1) {
            top = slice[0];
            bottom = slice[0];
            left = slice[0];
            right = slice[0];
        } else if (slice.length == 4) {
            top = slice[0];
            bottom = slice[1];
            left = slice[2];
            right = slice[3];
        } else {
            return;
        }
        int leftTopU = u;
        int leftTopV = v;
        int leftTopW = left;
        int leftTopH = top;
        int rightTopU = u + width - right;
        int rightTopV = v;
        int rightTopW = right;
        int rightTopH = top;
        int leftBottomU = u;
        int leftBottomV = v + height - bottom;
        int leftBottomW = left;
        int leftBottomH = bottom;
        int rightBottomU = u + width - right;
        int rightBottomV = v + height - bottom;
        int rightBottomW = right;
        int rightBottomH = bottom;
        ObjectiveUi.func_146110_a((int)x, (int)y, (float)leftTopU, (float)leftTopV, (int)leftTopW, (int)leftTopH, (float)textureWidth, (float)textureHeight);
        ObjectiveUi.func_146110_a((int)(x + finalWidth - rightTopW), (int)y, (float)rightTopU, (float)rightTopV, (int)rightTopW, (int)rightTopH, (float)textureWidth, (float)textureHeight);
        ObjectiveUi.func_146110_a((int)x, (int)(y + finalHeight - leftBottomH), (float)leftBottomU, (float)leftBottomV, (int)leftBottomW, (int)leftBottomH, (float)textureWidth, (float)textureHeight);
        ObjectiveUi.func_146110_a((int)(x + finalWidth - rightBottomW), (int)(y + finalHeight - rightBottomH), (float)rightBottomU, (float)rightBottomV, (int)rightBottomW, (int)rightBottomH, (float)textureWidth, (float)textureHeight);
        int topU = u + leftTopW;
        int topV = v;
        int topW = width - leftTopW - rightTopW;
        int topH = top;
        int topLength = finalWidth - leftTopW - rightTopW;
        int bottomU = u + leftBottomW;
        int bottomV = v + height - bottom;
        int bottomW = width - leftBottomW - rightBottomW;
        int bottomH = bottom;
        int bottomLength = finalWidth - leftBottomW - rightBottomW;
        int leftU = u;
        int leftV = v + top;
        int leftW = left;
        int leftH = height - leftTopH - leftBottomH;
        int leftLength = finalHeight - leftTopH - leftBottomH;
        int rightU = u + width - right;
        int rightV = v + top;
        int rightW = right;
        int rightH = height - rightTopH - rightBottomH;
        int rightLength = finalHeight - rightTopH - rightBottomH;
        float[] parameter = new float[]{x + left, y, (float)topLength / (float)topW, 1.0f, topU, topV, topW, topH, x + left, y + finalHeight - bottom, (float)bottomLength / (float)bottomW, 1.0f, bottomU, bottomV, bottomW, bottomH, x, y + top, 1.0f, (float)leftLength / (float)leftH, leftU, leftV, leftW, leftH, x + finalWidth - right, y + top, 1.0f, (float)rightLength / (float)rightH, rightU, rightV, rightW, rightH, x + left, y + top, (float)(finalWidth - left - right) / (float)(width - left - right), (float)(finalHeight - top - bottom) / (float)(height - top - bottom), u + left, v + top, width - left - right, height - top - bottom};
        for (int i = 0; i < parameter.length; i += 8) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)parameter[i], (float)parameter[i + 1], (float)0.0f);
            GlStateManager.func_179152_a((float)parameter[i + 2], (float)parameter[i + 3], (float)0.0f);
            ObjectiveUi.func_146110_a((int)0, (int)0, (float)parameter[i + 4], (float)parameter[i + 5], (int)((int)parameter[i + 6]), (int)((int)parameter[i + 7]), (float)textureWidth, (float)textureHeight);
            GlStateManager.func_179121_F();
        }
    }

    public static boolean mouseInRange(int mouseX, int mouseY, int x, int y, int w, int h2) {
        boolean a = mouseX > x && mouseX < x + w;
        boolean b = mouseY > y && mouseY < y + h2;
        return a && b;
    }

    public static class Button
    extends GuiButton {
        public Button(int id, int x, int y, String text) {
            super(id, x, y, 135, 20, text);
        }

        @ParametersAreNonnullByDefault
        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float tick) {
            if (this.field_146125_m) {
                this.field_146123_n = ObjectiveUi.mouseInRange(mouseX, mouseY, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                mc.field_71446_o.func_110577_a(TEX);
                Button.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)(this.field_146123_n ? 135.0f : 0.0f), (float)245.0f, (int)135, (int)20, (float)512.0f, (float)512.0f);
                this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + 67, this.field_146129_i + 6, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static class Scroll
    extends GuiScrollingList {
        private final Minecraft mc;
        public int select;

        public Scroll(Minecraft client, int width, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
            super(client, width, 0, top, bottom, left, entryHeight, screenWidth, screenHeight);
            this.mc = client;
        }

        protected int getSize() {
            return CONTENTS.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
            this.select = this.selectedIndex;
        }

        protected void drawSlot(int slot, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            Content content = CONTENTS.get(slot);
            boolean track = ConfigCache.mark.contains(content.title);
            this.mc.field_71446_o.func_110577_a(TEX);
            Gui.func_146110_a((int)(this.left + 4), (int)slotTop, (float)(track ? 135.0f : 0.0f), (float)225.0f, (int)135, (int)20, (float)512.0f, (float)512.0f);
            List text = this.mc.field_71466_p.func_78271_c(content.title, 110);
            this.mc.field_71466_p.func_78276_b((String)text.get(0) + (text.size() > 1 ? "...\u00a7r" : "\u00a7r"), this.left + 10, slotTop + 6, 0xFFFFFF);
        }

        protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        }
    }

    public static class Content {
        public String title;
        public String text;
        public String world;
        public ResourceLocation mark;
        public int x;
        public int y;
        public int z;
        public boolean traceable;

        public Content(String title, String location, String mark, String text) {
            this.title = title;
            this.text = text;
            boolean bl = this.traceable = mark.isEmpty() || location.isEmpty();
            if (!mark.isEmpty()) {
                this.mark = new ResourceLocation(mark);
            }
            if (!location.isEmpty()) {
                String[] split = location.split(":");
                String[] pos = split[1].split(",");
                this.world = split[0];
                this.x = Integer.parseInt(pos[0]);
                this.y = Integer.parseInt(pos[1]);
                this.z = Integer.parseInt(pos[2]);
            }
        }
    }
}

