/*
 * Decompiled with CFR 0.152.
 */
package nianshow.statusbar.entity;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import nianshow.statusbar.channel.ElementType;
import org.apache.commons.lang3.RandomUtils;

public class DamageNumber
extends EntityCreature {
    public static final Minecraft GAME = Minecraft.func_71410_x();
    public static final ResourceLocation TEX = new ResourceLocation("statusbar:textures/statusbar.png");
    public String number;
    public ElementType type;
    public boolean fatal;
    public float age = 100.0f;
    public double randomX = RandomUtils.nextDouble((double)0.0, (double)0.2) - 0.1;
    public double randomY = RandomUtils.nextDouble((double)0.0, (double)0.2) - 0.1;
    public double randomZ = RandomUtils.nextDouble((double)0.0, (double)0.2) - 0.1;

    private DamageNumber(World world) {
        super(world);
    }

    public int getTexPosition() {
        int position;
        switch (this.type) {
            case WIND: {
                position = 214;
                break;
            }
            case FIRE: {
                position = 247;
                break;
            }
            case THUNDER: {
                position = 346;
                break;
            }
            case WATER: {
                position = 280;
                break;
            }
            case LIGHT: {
                position = 313;
                break;
            }
            case HEAL: {
                position = 380;
                break;
            }
            default: {
                position = this.fatal ? 181 : 149;
            }
        }
        return position;
    }

    public static DamageNumber buildHeal(World world, String number) {
        return DamageNumber.build(world, number, false, ElementType.HEAL);
    }

    public static DamageNumber build(World world, String number, boolean fatal) {
        return DamageNumber.build(world, number, fatal, ElementType.NORMAL);
    }

    public static DamageNumber build(World world, String number, boolean fatal, ElementType type) {
        DamageNumber entity = new DamageNumber(world);
        entity.func_70105_a(0.1f, 0.1f);
        entity.func_70029_a(world);
        entity.number = number;
        entity.fatal = fatal;
        entity.type = type;
        if (entity.type != ElementType.NORMAL && entity.type != ElementType.HEAL) {
            entity.age = 80.0f;
        }
        return entity;
    }

    public void func_70071_h_() {
        this.age -= 2.0f;
        if (this.age < 1.0f) {
            this.func_70106_y();
        }
        float progress = this.age / 100.0f;
        this.func_70107_b(this.field_70165_t + this.randomX * (double)progress, this.field_70163_u + this.randomY * (double)progress, this.field_70161_v + this.randomZ * (double)progress);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public static class Render
    extends RenderLiving<DamageNumber> {
        public Render(RenderManager manager) {
            super(manager, (ModelBase)new ModelBiped(), 0.0f);
        }

        protected ResourceLocation getEntityTexture(@Nonnull DamageNumber entity) {
            return TEX;
        }

        @ParametersAreNonnullByDefault
        public void doRender(DamageNumber entity, double x, double y, double z, float entityYaw, float tick) {
            try {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-DamageNumber.GAME.field_71439_g.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)DamageNumber.GAME.field_71439_g.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(DamageNumber.GAME.field_71474_y.field_74320_O == 2 ? 270.0f : 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                if (entity.type == ElementType.NORMAL) {
                    GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
                } else {
                    GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
                }
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-((double)entity.number.length() * 0.5)));
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179097_i();
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(entity.age / 100.0f));
                float scale = 0.001953125f;
                float size = 32.0f * scale;
                DamageNumber.GAME.field_71446_o.func_110577_a(TEX);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                for (int i = 0; i < entity.number.length(); ++i) {
                    int number = Character.getNumericValue(entity.number.charAt(i));
                    float[] pos = new float[]{(float)(number * 32) * scale, (float)entity.getTexPosition() * scale};
                    builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)pos[0], (double)pos[1]).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)pos[0], (double)(pos[1] + size)).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 1.0).func_187315_a((double)(pos[0] + size), (double)(pos[1] + size)).func_181675_d();
                    builder.func_181662_b(0.0, 0.0, 1.0).func_187315_a((double)(pos[0] + size), (double)pos[1]).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

