/*
 * Decompiled with CFR 0.152.
 */
package nianshow.statusbar.channel;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import nianshow.statusbar.channel.DPSCentral;
import nianshow.statusbar.channel.ElementDamageCentral;
import nianshow.statusbar.channel.ElementType;
import nianshow.statusbar.entity.DamageNumber;
import nianshow.statusbar.gui.ObjectiveUi;
import nianshow.statusbar.gui.StatusUi;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

public class StatusChannel {
    private int count = 4;
    private final ConcurrentHashMap<Integer, Integer> healData = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> numberData = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Boolean> fatalData = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, ElementDamageCentral> elements = new ConcurrentHashMap();
    private final FMLEventChannel channel;
    private final DPSCentral central;

    public StatusChannel(FMLEventChannel channel) {
        channel.register((Object)this);
        this.channel = channel;
        this.central = new DPSCentral();
        this.central.start();
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        try {
            String header;
            ByteBuf buf = e.getPacket().payload();
            byte[] bytes = new byte[buf.readableBytes()];
            while (buf.isReadable()) {
                bytes[buf.readerIndex()] = buf.readByte();
            }
            MessageUnpacker pack = MessagePack.newDefaultUnpacker(bytes);
            switch (header = pack.unpackString()) {
                case "reset-dps": {
                    this.central.reset();
                    break;
                }
                case "init": {
                    StatusUi.visible = true;
                    break;
                }
                case "damage": {
                    int attackId = pack.unpackInt();
                    int id = pack.unpackInt();
                    int damage = pack.unpackInt();
                    int number = this.numberData.getOrDefault(id, 0);
                    this.numberData.put(id, number += damage);
                    boolean fatal = this.fatalData.getOrDefault(id, false);
                    if (!fatal) {
                        this.fatalData.put(id, pack.unpackBoolean());
                    }
                    if (DamageNumber.GAME.field_71439_g.func_145782_y() != attackId) break;
                    this.central.addDamage(ElementType.NORMAL, damage);
                    break;
                }
                case "element": {
                    int attackEntityId = pack.unpackInt();
                    int entityId = pack.unpackInt();
                    boolean dps = DamageNumber.GAME.field_71439_g.func_145782_y() == attackEntityId;
                    ElementDamageCentral central = elements.computeIfAbsent(entityId, ElementDamageCentral::new);
                    while (pack.hasNext()) {
                        ElementType elementType = ElementType.valueOf(pack.unpackString().toUpperCase());
                        int elementNumber = pack.unpackInt();
                        central.addElement(elementType, elementNumber);
                        if (!dps) continue;
                        this.central.addDamage(elementType, elementNumber);
                    }
                    break;
                }
                case "heal": {
                    int targetId = pack.unpackInt();
                    int healNumber = this.numberData.getOrDefault(targetId, 0);
                    this.healData.put(targetId, healNumber += pack.unpackInt());
                    break;
                }
                case "level": {
                    StatusUi.level = pack.unpackFloat();
                    break;
                }
                case "magic": {
                    StatusUi.nowMagic = pack.unpackFloat();
                    StatusUi.maxMagic = pack.unpackFloat();
                    break;
                }
                case "experience": {
                    StatusUi.nowExp = pack.unpackFloat();
                    StatusUi.maxExp = pack.unpackFloat();
                    break;
                }
                case "world": {
                    ObjectiveUi.worldName = pack.unpackString();
                    break;
                }
                case "clearObjective": {
                    ObjectiveUi.CONTENTS.clear();
                    break;
                }
            }
            pack.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase.equals((Object)TickEvent.Phase.END) && Minecraft.func_71410_x().field_71441_e != null) {
            ++this.count;
            if (this.count >= 1) {
                DamageNumber entity;
                Entity target;
                this.count = 0;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                for (Map.Entry<Integer, Integer> entry : this.numberData.entrySet()) {
                    target = world.func_73045_a(entry.getKey().intValue());
                    if (target == null) continue;
                    entity = DamageNumber.build((World)world, Integer.toString(entry.getValue()), this.fatalData.getOrDefault(entry.getKey(), false));
                    entity.func_70107_b(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 1.2, target.field_70161_v);
                    world.func_72838_d((Entity)entity);
                }
                for (Map.Entry<Integer, Integer> entry : this.healData.entrySet()) {
                    target = world.func_73045_a(entry.getKey().intValue());
                    if (target == null) continue;
                    entity = DamageNumber.buildHeal((World)world, Integer.toString(entry.getValue()));
                    entity.func_70107_b(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 1.2, target.field_70161_v);
                    world.func_72838_d((Entity)entity);
                }
                elements.values().forEach(arg_0 -> StatusChannel.lambda$onTick$0((World)world, arg_0));
                this.numberData.clear();
                this.fatalData.clear();
                this.healData.clear();
            }
        }
    }

    public DPSCentral getCentral() {
        return this.central;
    }

    private static /* synthetic */ void lambda$onTick$0(World world, ElementDamageCentral central) {
        central.release(world);
    }
}

