/*
 * Decompiled with CFR 0.152.
 */
package mc.tale_sh.mod.epicofelementmod.message;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import mc.tale_sh.mod.epicofelementmod.events.AttackEvent;
import mc.tale_sh.mod.epicofelementmod.events.FlyEvent;
import mc.tale_sh.mod.epicofelementmod.events.ShieldEvent;
import mc.tale_sh.mod.epicofelementmod.gui.GuiFinish;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class JsonMessage
implements IMessage,
IMessageHandler<JsonMessage, IMessage> {
    public String msg;

    public IMessage onMessage(JsonMessage message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            String str = message.msg;
            JsonParser parser = new JsonParser();
            parser.parse(str);
            final JsonObject json = (JsonObject)parser.parse(str);
            String cmd = json.get("cmd").getAsString();
            if (cmd.equals("TakeDrug")) {
                AttackEvent.setFireProgressBar(json);
            } else if (cmd.equals("TakeBlockAction")) {
                AttackEvent.setBlockActionGetting(json);
            } else if (cmd.equals("StopBlockAction")) {
                AttackEvent.stopBlockActionGetting();
            } else if (cmd.equals("SetEndurance")) {
                FlyEvent.setEndurance(json);
            } else if (cmd.equals("UpEndurance")) {
                FlyEvent.upEndurance(json);
            } else if (cmd.equals("DownEndurance")) {
                FlyEvent.downEndurance(json);
            } else if (cmd.equals("FinishDungeon")) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFinish(json));
                    }
                }, 2000L);
            } else if (cmd.equals("ShieldInfo")) {
                double value = json.get("Value").getAsDouble();
                double left = json.get("Left").getAsDouble();
                double recovery = json.get("Recovery").getAsDouble();
                ShieldEvent.setShieldInfo(new ShieldEvent.ShieldInfo(value, left, recovery));
            }
        });
        return null;
    }

    public JsonMessage() {
    }

    public JsonMessage(String msg) {
        this.msg = msg;
    }

    public void fromBytes(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        try {
            this.msg = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeBytes(this.msg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

