/*
 * Decompiled with CFR 0.152.
 */
package mc.tale_sh.mod.epicofelementmod.events;

import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ShieldEvent {
    private static final ResourceLocation SHIELD_BAR = new ResourceLocation("epicofelementmod:textures/hud/shieldbar.png");
    private static final ResourceLocation SHIELD = new ResourceLocation("epicofelementmod:textures/hud/shield.png");
    private static ShieldInfo lastShieldInfo;
    private static ShieldInfo shieldInfo;
    private static Timer timer;
    private static int animIndex;

    public ShieldEvent() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void setShieldInfo(ShieldInfo shieldInfo) {
        if (timer != null) {
            timer.cancel();
            animIndex = -1;
        }
        lastShieldInfo = ShieldEvent.shieldInfo;
        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                animIndex++;
                if (animIndex > 20) {
                    timer.cancel();
                    animIndex = -1;
                }
            }
        }, 0L, 50L);
        ShieldEvent.shieldInfo = shieldInfo;
    }

    @SubscribeEvent
    public void showShieldBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && shieldInfo != null) {
            ItemStack item = (ItemStack)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_184439_c.get(0);
            if (item.func_190926_b() || item.func_77973_b() != Items.field_185159_cQ) {
                lastShieldInfo = null;
                shieldInfo = null;
                timer.cancel();
                animIndex = -1;
                return;
            }
            final int width = event.getResolution().func_78326_a();
            final int height = event.getResolution().func_78328_b();
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(width / 2 - 117), (float)(height - 60), (float)0.0f);
                    mc.func_110434_K().func_110577_a(SHIELD_BAR);
                    Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)90, (int)13, (float)90.0f, (float)13.0f);
                    mc.func_110434_K().func_110577_a(SHIELD);
                    double lastLeft = lastShieldInfo == null ? shieldInfo.left : lastShieldInfo.left;
                    double left = animIndex == -1 ? shieldInfo.left : lastLeft + (shieldInfo.left - lastLeft) * ((double)animIndex / 20.0);
                    Gui.func_146110_a((int)15, (int)5, (float)0.0f, (float)0.0f, (int)((int)(70.0 * left / shieldInfo.value)), (int)6, (float)70.0f, (float)6.0f);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(width / 2 - 117 + 45), (float)(height - 70), (float)0.0f);
                    String text = (int)left + "/" + (int)shieldInfo.value;
                    mc.field_71466_p.func_78276_b(text, -(mc.field_71466_p.func_78256_a(text) / 2), 0, Color.white.getRGB());
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                }
            });
        }
    }

    static {
        animIndex = -1;
    }

    public static class ShieldInfo {
        private double value;
        private double left;
        private double recovery;

        public ShieldInfo(double value, double left, double recovery) {
            this.value = value;
            this.left = left;
            this.recovery = recovery;
        }
    }
}

