/*
 * Decompiled with CFR 0.152.
 */
package mc.tale_sh.mod.epicofelementmod.events;

import com.google.gson.JsonObject;
import mc.tale_sh.mod.epicofelementmod.EpicOfElementMod;
import mc.tale_sh.mod.epicofelementmod.message.JsonMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class AttackEvent {
    private static final ResourceLocation FIRE_PROGRESS_BAR = new ResourceLocation("epicofelementmod:textures/hud/fireprogressbar.png");
    private static ProgressBar fireProgressBar;
    private static final ResourceLocation BLOCK_ACTION_PROGRESS;
    private static final ResourceLocation BLOCK_ACTION_PROGRESS_BAR;
    private static ProgressBar blockActionProgressBar;

    public AttackEvent() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Mouse.getEventButton() == 0) {
            JsonObject json = new JsonObject();
            if (Mouse.getEventButtonState()) {
                if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                    BlockPos blockpos = mc.field_71476_x.func_178782_a();
                    json.addProperty("cmd", "LeftPress");
                    json.addProperty("x", (Number)blockpos.func_177958_n());
                    json.addProperty("y", (Number)blockpos.func_177956_o());
                    json.addProperty("z", (Number)blockpos.func_177952_p());
                    EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
                }
            } else {
                json.addProperty("cmd", "LeftRelease");
                EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
                if (fireProgressBar != null && AttackEvent.fireProgressBar.action == Action.LEFT_PRESS) {
                    fireProgressBar = null;
                }
                if (blockActionProgressBar != null && AttackEvent.blockActionProgressBar.action == Action.LEFT_PRESS) {
                    blockActionProgressBar = null;
                }
            }
        } else if (Mouse.getEventButton() == 1) {
            JsonObject json = new JsonObject();
            if (Mouse.getEventButtonState()) {
                if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                    BlockPos blockpos = mc.field_71476_x.func_178782_a();
                    json.addProperty("cmd", "RightPress");
                    json.addProperty("x", (Number)blockpos.func_177958_n());
                    json.addProperty("y", (Number)blockpos.func_177956_o());
                    json.addProperty("z", (Number)blockpos.func_177952_p());
                    EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
                }
            } else {
                json.addProperty("cmd", "RightRelease");
                EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
                if (fireProgressBar != null && AttackEvent.fireProgressBar.action == Action.RIGHT_PRESS) {
                    fireProgressBar = null;
                }
                if (blockActionProgressBar != null && AttackEvent.blockActionProgressBar.action == Action.RIGHT_PRESS) {
                    blockActionProgressBar = null;
                }
            }
        } else if (Mouse.getEventButton() == -1) {
            JsonObject json;
            if (fireProgressBar != null && this.blockMove(fireProgressBar)) {
                fireProgressBar = null;
                json = new JsonObject();
                json.addProperty("cmd", "StopFire");
                EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
            }
            if (blockActionProgressBar != null && this.blockMove(blockActionProgressBar)) {
                json = new JsonObject();
                json.addProperty("cmd", "StopBlockAction");
                EpicOfElementMod.getNetwork().sendToServer((IMessage)new JsonMessage(json.toString()));
            }
        }
    }

    public boolean blockMove(ProgressBar progressBar) {
        BlockPos blockpos;
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK || mc.field_71476_x.func_178782_a() == null || !progressBar.pos.equals((Object)(blockpos = mc.field_71476_x.func_178782_a()));
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (fireProgressBar != null && (double)AttackEvent.fireProgressBar.start + AttackEvent.fireProgressBar.time * 1000.0 <= (double)Minecraft.func_71386_F()) {
                fireProgressBar = null;
            }
            if (blockActionProgressBar != null && (double)AttackEvent.blockActionProgressBar.start + AttackEvent.blockActionProgressBar.time * 1000.0 <= (double)Minecraft.func_71386_F()) {
                blockActionProgressBar = null;
            }
        }
    }

    public static void setFireProgressBar(JsonObject json) {
        fireProgressBar = new ProgressBar(json.get("x").getAsInt(), json.get("y").getAsInt(), json.get("z").getAsInt(), json.get("time").getAsDouble(), Action.values()[json.get("action").getAsInt()]);
    }

    public static void setBlockActionGetting(JsonObject json) {
        blockActionProgressBar = new ProgressBar(json.get("x").getAsInt(), json.get("y").getAsInt(), json.get("z").getAsInt(), json.get("time").getAsDouble(), Action.values()[json.get("action").getAsInt()]);
    }

    public static void stopBlockActionGetting() {
        blockActionProgressBar = null;
    }

    @SubscribeEvent
    public void showBlockActionBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            final int width = event.getResolution().func_78326_a();
            final int height = event.getResolution().func_78328_b();
            if (fireProgressBar != null) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        Minecraft mc = Minecraft.func_71410_x();
                        mc.field_71446_o.func_110577_a(FIRE_PROGRESS_BAR);
                        GlStateManager.func_179094_E();
                        double scale = 0.5;
                        GlStateManager.func_179137_b((double)((double)(width / 2) - 95.0 * scale), (double)((double)height - 200.0 * scale), (double)0.0);
                        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Gui.func_146110_a((int)0, (int)0, (float)7.0f, (float)9.0f, (int)189, (int)35, (float)202.0f, (float)122.0f);
                        Gui.func_146110_a((int)1, (int)3, (float)8.0f, (float)53.0f, (int)((int)(187.0 * (double)(Minecraft.func_71386_F() - fireProgressBar.start) / (fireProgressBar.time * 1000.0))), (int)29, (float)202.0f, (float)122.0f);
                        Gui.func_146110_a((int)10, (int)6, (float)12.0f, (float)91.0f, (int)15, (int)25, (float)202.0f, (float)122.0f);
                        GlStateManager.func_179121_F();
                        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
                    }
                });
            } else if (blockActionProgressBar != null) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        Minecraft mc = Minecraft.func_71410_x();
                        GlStateManager.func_179094_E();
                        double scale = 0.5;
                        GlStateManager.func_179137_b((double)((double)(width / 2) - 160.0 * scale), (double)((double)height - 200.0 * scale), (double)0.0);
                        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        mc.field_71446_o.func_110577_a(BLOCK_ACTION_PROGRESS);
                        Gui.func_146110_a((int)0, (int)0, (float)80.0f, (float)76.0f, (int)320, (int)11, (float)511.0f, (float)185.0f);
                        mc.field_71446_o.func_110577_a(BLOCK_ACTION_PROGRESS_BAR);
                        Gui.func_146110_a((int)3, (int)3, (float)83.0f, (float)79.0f, (int)((int)(314.0 * (double)(Minecraft.func_71386_F() - blockActionProgressBar.start) / (blockActionProgressBar.time * 1000.0))), (int)5, (float)511.0f, (float)185.0f);
                        GlStateManager.func_179121_F();
                        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent e) {
        if (fireProgressBar != null || blockActionProgressBar != null) {
            Minecraft.func_71410_x().field_71438_f.func_72731_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71476_x, 0, e.getPartialTicks());
        }
    }

    static {
        BLOCK_ACTION_PROGRESS = new ResourceLocation("epicofelementmod:textures/hud/blockaction.png");
        BLOCK_ACTION_PROGRESS_BAR = new ResourceLocation("epicofelementmod:textures/hud/blockactionbar.png");
    }

    public static enum Action {
        LEFT_PRESS,
        LEFT_RELEASE,
        RIGHT_PRESS,
        RIGHT_RELEASE;

    }

    public static class ProgressBar {
        public BlockPos pos;
        public long start;
        public double time;
        public Action action;

        public ProgressBar(int x, int y, int z, double time, Action action) {
            this.pos = new BlockPos(x, y, z);
            this.start = Minecraft.func_71386_F();
            this.time = time;
            this.action = action;
        }
    }
}

